@extends('admin.layouts.admin-layout')
<link rel="stylesheet" href="{{ asset('css/invoices.css') }}">

@section('content')
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
        <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Invoices</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                <li class="breadcrumb-item active">Dashboard v1</li>
                </ol>
            </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
        </div>
    <!-- /.content-header -->

<!-- Main content -->
<body>
  <!-- Search invoices -->

<section class="content">
    <div class="container-fluid">
<div>
    @if(session('success'))
<div class="alert alert-success">
{{ session('success') }}
</div>
@endif
<div class="container">
    <h1>Monthly Report</h1>

    <table class="table">
        <thead>
            <tr>
                <th>Month</th>
                <th>Total Amount Paid</th>
                <th>Total Amount Unpaid</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($monthlyReports as $report)
            <tr>
                <td>{{ $report['month'] }}</td>
                <td>${{ number_format($report['total_amount_paid'], 2) }}</td>
                <td>${{ number_format($report['total_amount_unpaid'], 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

@endsection
<script>
    // JavaScript to toggle the sidebar
    document.addEventListener("DOMContentLoaded", function() {
        const sidebar = document.getElementById('sidebar');
        const toggleButton = document.getElementById('toggleSidebar');

        toggleButton.addEventListener('click', function() {
            sidebar.classList.toggle('collapsed');
        });
    });
</script>
