@extends('admin.layouts.admin-layout')

@section('content')

    <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">ROOMS</h1>
                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard v1</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->

                <!-- /.content-header -->

                 <!-- Assign apartment (Page header) -->
                 <div class="row">
                <form method="POST" action="{{ route('roomsApartments') }}">
                    @csrf
                    <div class="row">
                        <table>
                            <thead>
                                <th> <label for="user_id">Select Room ID:</label></th>
                                <th><label for="room_id">Room Name/Number:</label></th>
                                <th><label for="room_id">Select a Apartment:</label></th>
                            </thead>


                            <td>
                    <div class="form-group">
                        <label for="room_id">Room ID</label>
                        <select name="room_id" id="room_id" class="form-control">
                            @foreach ($rooms as $room)
                                <option value="{{ $room->id }}">{{ $room->id }}</option>
                            @endforeach
                        </select>
                    </div>
                </td>

                <td>
                    <div class="form-group">
                        <label for="room_number">Room Number (Auto-Generated)</label>
                        <input type="text" name="room_number" id="room_number" class="form-control" readonly>
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="apartment_id">Apartment</label>
                        <select name="apartment_id" id="apartment_id" class="form-control">
                            @foreach ($apartments as $apartment)
                                <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </td>

                <td>
                    <button type="submit" class="btn btn-primary">Assign Room to Apartment</button>
                </td>
                </form>
                @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                    <div class="alert alert-error">
                        {{ session('error') }}
                    </div>
                @endif
                 </div>
            </div>

                <!--Rooms Listing--->
                <div class="row">
                <section >
                    <div class="container-fluid">
                        <h1>Rooms Listing</h1>
                            <!--Table--->


                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Apartment</th>

                                    <th>Room Price</th>
                                    <th>Balance</th>
                                    <th>Room Status</th>


                            </thead>
                            <tbody>
                                @foreach ($rooms as $room)
                                    <tr>
                                        <td>{{ $room->id }}</td>
                                        <td>{{ $room->room_number }}</td>
                                        <td>
                                            @if ($room->apartments->isNotEmpty())
                                                {{ $room->apartments->first()->pivot->apartment_name }}
                                            @else
                                                No Apartment Assigned
                                            @endif
                                        </td>
                                        <td>{{ $room->price }}</td>
                                        <td> Balance</td>
                                        <td>
                                            @if ($room->users->count() > 0)
                                                Occupied
                                            @else
                                                Available
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                </table>
                    <!--End Table--->
                </div>
                <!-- /.row (main row) -->
                </section>

            </div>
@endsection
@section('scripts')
<script>
    // Listen for changes in the room ID dropdown
    document.getElementById('room_id').addEventListener('change', function () {
        // Get the selected room ID
        const selectedRoomId = this.value;

        // Generate a room number (adjust as needed)
        const generatedRoomNumber = 'R' + selectedRoomId;

        // Update the room number input field
        document.getElementById('room_number').value = generatedRoomNumber;
    });
</script>
<!-- Admin-specific scripts here -->
@endsection
