@extends('admin.layouts.admin-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Support Tickets</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <div class="container">
    <div class="row">
        <div id="sweet-alert-container"></div>
        <table class="table">

            <tr>
                <th>#</th>
                <th>F</th>
                <th>Department</th>
                <th>Subject</th>
                <th>Requestor</th>
                <th>Status</th>
                <th>Last Reply</th>
            </tr>
            @foreach ($tickets as $ticket)
            <tr>
                <td><input type="checkbox" class="ticket-checkbox" data-ticket-id="<?php echo $ticket->id; ?>"></td>
                <td></td>
                <td>Department</td>
                <td><a href="{{ route('tickets.show', $ticket) }}">#{{ $ticket->id }}-{{ $ticket->subject }}</a></td>
                <td>{{ $ticket->user->name }}</td>
                <td>{{ $ticket->status }}</td>
                <td>{{ $ticket->updated_at->diffForHumans() }}</td>
                <td><a href="{{ route('tickets.show', $ticket) }}">Reply</a></td>

            </tr>
            @endforeach
        </table>
    </div>
</div>

@endsection
