
@extends('admin.layouts.admin-layout')
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- Add the Bootstrap CSS link -->
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

<!-- Add the Bootstrap JavaScript and jQuery (if required) -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<style>
    table {
      border-collapse: collapse;
      width: 100%;
    }

    th, td {
      border: 1px solid #ddd;
      text-align: left;
      padding: 8px;
    }

    /* Set width for specific columns */
    th:nth-child(1), td:nth-child(1) {
      width: 30%; /* Adjust the width as needed */
    }

    th:nth-child(2), td:nth-child(2) {
      width: 15%; /* Adjust the width as needed */
    }

    th:nth-child(3), td:nth-child(3) {
      width: 15%; /* Adjust the width as needed */
    }
    th:nth-child(4), td:nth-child(3) {
      width: 15%; /* Adjust the width as needed */
    }
    /* Add more columns as needed */

    </style>
@section('content')

    <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">ROOM OCCUPIED</h1>
                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard v1</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.container-fluid -->
                    </div>
                <!-- /.content-header -->

            <!-- Main content -->

                <section class="content">
                <div class="container-fluid">
                <!-- Small boxes (Stat box) -->
                    <div class="row">
                        <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-info">
                            <div class="inner">
                            {{-- <h3>{{ $totalusers}}</h3> --}}
5
                            <p>Totals Users</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-bag"></i>
                            </div>
                            <a href="{{ route('roomsoccupied') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                        </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                        <h3>50<sup style="font-size: 20px">%</sup></h3>

                        <p>Pending</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="admin/pages/thismonth.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                        <h3>1400</h3>

                        <p>Active</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-person-add"></i>
                        </div>
                        <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                        <h3>120</h3>

                        <p>Disabled</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="admin/pages/thismonth.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                </div>
                <!-- /.row -->
                <!-- Main row -->
                </div>
                </section>

                <!-- ASSIGN USERS -->
                <section >
                <div class="container bg-grey">
                    <div class="card">
                        <div class="card-header">
                    <div class="row " style="overflow:hidden;">
                        <div class="col-12">
                        <h3>{{ __('Assign User to a Room') }}</h3>
                        </div>
                    </div>
                        </div>
                    </div>



                    <div class="card-body">
                        <div class="row" style="border: 1px solid blue;">
                            <form id="assignRoomForm" method="POST" action="{{ route('assign.apartment.store') }}">
                                @csrf
                                <table>
                                    <thead>
                                        <tr>
                                            <th>{!! Form::label('user', 'Select User') !!}</th>
                                            <th>{!! Form::label('apartment', 'Select Apartment') !!}</th>
                                            <th>{!! Form::label('room', 'Select Room') !!}</th>
                                        </tr>
                                        <tbody>
                                            <td>{!! Form::select('user', $users->pluck('id', 'id')->map(function ($item) use ($users) {
                                                $user = $users->where('id', $item)->first();
                                                return $user->id . ' - ' . $user->surname . ' - ' . $user->email;
                                            }), null, ['class' => 'form-control', 'id' => 'user']) !!}</td>
                                            <td>{!! Form::select('apartment', [], null, ['class' => 'form-control', 'id' => 'apartment']) !!}</td>
                                            <td>{!! Form::select('room', [], null, ['class' => 'form-control', 'id' => 'room']) !!}</td>
                                            <td><button id="assignButton" class="btn btn-primary">Assign</button></td>
                                        </tbody>
                                    </thead>
                                </table>

                            </form>
                           @include('partials._message_box')
                        </div>
                    </div>
                </div>
                </section>
                    <!-- /-ASSIGN USERS -->
<!-- resources/views/assign-apartment.blade.php -->

<div class="row">
    <div class="card">
        <div class="card-header">
            {{ __('Assign User Apartment')}}
        </div>
        <div class="card-body">
            <form id="assignRoomFor" method="POST" action="{{ route('assign.apartment.store')}}">
                @csrf
                <table>
                    <thead>
                        <tr>
                            <th>{!! Form::label('user', 'Select User') !!}</th>
                            <th>{!! Form::label('apartment', 'Select Apartment') !!}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{!! Form::select('user_id', $users->pluck('surname', 'id'), null, ['class' => 'form-control', 'id' => 'user']) !!}</td>
                            <td>{!! Form::select('apartment_id', $apartments->pluck('name', 'id'), null, ['class' => 'form-control', 'id' => 'apartment']) !!}</td>
                            <td><button id="assignButton" type="submit" class="btn btn-primary">Assign</button></td>
                        </tr>
                    </tbody>
                </table>
            </form>

        </div>
    </div>
</div>
<div class="container">
    <h4>Assign User to Apartment</h4>
  @include('partials._message_box')

    {{-- <form method="POST" action="{{ route('assign.apartment.store') }}">
        @csrf
        <table class="table">
            <tr>
                <td>{!! Form::label('user', 'Select User') !!}</td>
                <td>
                    <select name="user" id="user" class="form-control">
                        @foreach ($users as $user)
                            <option value="{{ $user->id }}">{{ $user->id }} - {{ $user->surname }} - {{ $user->email }}</option>
                        @endforeach
                    </select>
                </td>
            </tr>
            <tr>
                <td>{!! Form::label('apartment', 'Select Apartment') !!}</td>
                <td>
                    <select name="apartment" id="apartment" class="form-control">
                        @foreach ($apartments as $apartment)
                            <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
                        @endforeach
                    </select>
                </td>
            </tr>
        </table>
        <button type="submit" class="btn btn-primary">Assign Apartment</button>
    </form> --}}
</div>



                  <!--Rooms Listing--->
                  <section class="content">
                    <div class="container-fluid">
                        <h1>User Profile</h1>
                            <!--Table--->


                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>User Status</th>
                                    <th>Apartment</th>
                                    <th>Room No</th>
                                    <th>Room Price</th>
                                    <th>Balance</th>
                                    <th>Room Status</th>


                            </thead>
                            <tbody>
                                @foreach ($users as $user )
                                @foreach ($user->rooms as $room)
                                <tr>
                                    <td><strong>{{ $user->id }}</strong> </td>
                            <td><strong>{{ $user->name }}</strong> </td>
                            <td><strong></strong> {{ $user->email }}</td>

                            <td><strong>
                                @if($user->status === 'active')
                                    <span style="color: green;">Active</span>
                                @elseif($user->status === 'inactive')
                                    <span style="color: red;">Inactive</span>
                                @else
                                    <span>Unknown</span>
                                @endif
                            </strong>
                            </td>

                            <td>
                                <strong>{{ $room->apartments->first()->pivot->apartment_name }}</strong>
                            </td>
                            <td>
                                <ul>

                                        <li>{{ $room->room_number }}</li>

                                </ul>
                            </td>
                            <td>{{ $room->price }}</td>

                            <td><strong> @php
                                $roomBalance = 0;
                                foreach ($room->invoices as $invoice) {
                                    $roomBalance += $invoice->total_amount - $invoice->amount_paid;
                                }
                            @endphp
                            {{ $roomBalance }}</strong> </td>
                            <td><strong>
                                @if ($room->room_number)
                                <span style="color: green;">HAS Room</span>
                            @else
                                <span style="color: red;">Not Assigned</span>
                            @endif
                                </strong> </td>
                                </tr>

                            @endforeach
                            @endforeach
                            </tbody>
                        </table>
                    <!--End Table--->
                </div>
                <!-- /.row (main row) -->
                </section>


                </div>
                {{-- </section> --}}
        </div>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $(document).ready(function() {
    const userSelect = $('#user');
    const apartmentSelect = $('#apartment');
    const roomSelect = $('#room');


    userSelect.on('change', function() {
        const selectedUserId = $(this).val();

        $.ajax({
            url: '/admin/Users/get-apartments',
            type: 'GET',
            dataType: 'json',
            success: function(apartments) {
                var apartmentSelect = $('#apartment');
                apartmentSelect.empty();
                apartmentSelect.append($('<option>', {
                    value: '',
                    text: 'Select Apartment',
                }));

                $.each(apartments, function(index, apartment) {
                    apartmentSelect.append($('<option>', {
                        value: apartment.id,
                        text: apartment.name,
                    }));
                });
            },
        });
    });

    apartmentSelect.on('change', function() {
        const selectedApartmentId = $(this).val();

        $.ajax({
            url: '/admin/Users/get-rooms/' + selectedApartmentId,
            type: 'GET',
            dataType: 'json',
            success: function(rooms) {
                var roomSelect = $('#room');
                roomSelect.empty();
                roomSelect.append($('<option>', {
                    value: '',
                    text: 'Select Room',
                }));

                $.each(rooms, function(index, room) {
            roomSelect.append($('<option>', {
                value: room.room_id,
                text: room.room_number,
                    }));
                });
            },
        });
    });

    $('#assignButton').on('click', function() {
        const selectedUserId = userSelect.val();
        const selectedRoomId = roomSelect.val();

        // Perform the assignment logic here
    });
});

</script>


<!-- Admin-specific scripts here -->
{{-- <script>
    $(document).ready(function () {
        $('#apartment-select').on('change', function () {
            var apartmentId = $(this).val();
            if (apartmentId) {
                $.ajax({
                    url: '{{ route('api.get.rooms') }}/' + apartmentId,
                    type: 'GET',
                    dataType: 'json',
                    success: function (data) {
                        $('#room-select').empty();
                        $.each(data, function (key, value) {
                            $('#room-select').append('<option value="' + key + '">' + value + '</option>');
                        });
                    }
                });
            } else {
                $('#room-select').empty();
            }
        });
    });
</script> --}}
@endsection
