
@extends('layouts.app')
@section('content')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.min.css" />
<script src='https://www.google.com/recaptcha/api.js'></script>






<main id="main" >

<div class="row" >
    <div class="container mt-5">

<section class="h-100 bg-dark1">
  <div class="container py-5 h-100">
    <div class="row d-flex justify-content-center align-items-center h-100">
      <div class="col">
        <div class="card card-registration my-4">
          <div class="row g-0">
            <div class="col-xl-6 d-none d-xl-block">
              <img src="https://mdbcdn.b-cdn.net/img/Photos/new-templates/bootstrap-registration/img4.webp"
                alt="Sample photo" class="img-fluid"
                style="border-top-left-radius: .25rem; border-bottom-left-radius: .25rem;" />
            </div>
            <div class="col-xl-6">
              <div class="card-body p-md-5 text-black">
                <h3 class="text-uppercase">Create your account</h3>

                @if ($errors->any())
                     @foreach ($errors->all() as $error)
                         <div class="text-danger">{{$error}}</div>
                     @endforeach
                 @endif


              <h5 class="text-danger">@if(\Session::has('email')) {{ \Session::get('email') }}  @endif @if(\Session::has('phone')) {{ \Session::get('phone') }}  @endif</h5>
            <form method="post" action="{{ route('register') }}" id="msRegister1" autocomplete="off">
                @csrf
                <div class="row">
                  <div class="col-md-6 mb-4">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1m">First name</label>
                      <input type="text"  class="form-control form-control-lg" name="fname" id="fname" required autocomplete="off" />

                    </div>
                  </div>
                  <div class="col-md-6 mb-4">
                    <div class="form-outline">
                         <label class="form-label" for="form3Example1n">Middle name (optional)</label>
                      <input type="text"  class="form-control form-control-lg" name="mname" id="mname"  autocomplete="off" />

                    </div>
                  </div>
                </div>






                <div class="row">
                  <div class="col-md-6 mb-4">
                    <label class="form-label" for="form3Example99">Last name</label>
                    <input name="lname" type="text"  class="form-control form-control-lg" id="lname" required autocomplete="off" />


                  </div>
                  <div class="col-md-6 mb-4">
                    <label class="form-label" for="form3Example99">Username</label>
                   <input name="username" type="text"  class="form-control form-control-lg" id="username" required autocomplete="off" />

                  </div>
                </div>
                   <label class="form-label" for="form3Example99">Gender</label> <br>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="gender" id="gender" value="male" required autocomplete="off">
                  <label class="form-check-label" for="inlineRadio1">Male</label>
                </div>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="gender" id="gender" value="female" required autocomplete="off">
                  <label class="form-check-label" for="inlineRadio2">Female</label>
                </div>

                <div class="form-outline mb-4">
                    <label class="form-label" for="form3Example90">Email</label>
                  <input name="email" type="email"  class="form-control form-control-lg" id="email" required autocomplete="off" />


                   <div class="email-error" style="font-weight:bold;color:red">

                  </div>
                </div>

                <div class="form-outline mb-4">
                    <label class="form-label" for="form3Example99">Phone</label>
                  <input name="phone" type="number"  class="form-control form-control-lg" id="phone" required autocomplete="off" disabled />


                  <div class="phone-error" style="font-weight:bold;color:red">

                  </div>


                </div>

                <div class="form-outline mb-4">
                    <label class="form-label" for="form3Example97">Password</label>
                  <input name="password" type="password"  class="form-control form-control-lg" id="password" />

                </div>

                <div class="form-outline mb-4">
                     <label class="form-label" for="form3Example97">Confirm Password</label>
                  <input name="password_confirmation" type="password"  class="form-control form-control-lg" id="password_confirmation" />


                   <div class="password-error" style="font-weight:bold;color:red">

                    </div>

                </div>

                 <div class="form-outline mb-4">

                  <input value="{{  $code ?? ' ' }}" name="referral_code" type="hidden"  class="form-control form-control-lg" id="refferal_code" />

                </div>

                <div class="form-check">
                  <input class="form-check-input position-static" type="checkbox" id="" value="terms" aria-label="..." required />
                 <p>I agree to <a href="/terms">terms</a> of use and <a href="/privacy-policy">privacy policy</a></p>
                </div>

                <div class="form-check">
                  <input class="form-check-input position-static" type="checkbox" id="confirm" value="" aria-label="..." required />
                  <p>I confirm that the above details are mine and cannot be changed</p>
                </div>

                <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITEKEY') }}"></div>
                @if ($errors->has('g-recaptcha-response'))
                    <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                @endif



                <div class="d-flex justify-content-end pt-3">

                  <button type="submit" class="btn btn-warning btn-lg ms-2" id="submit" disabled>Submit form</button>
                </div>

                <div class="success" style="font-weight:bold;color:red">

                </div>
            </form>

            <div class="d-flex justify-content-end pt-3">
                  <p>Already have an account?<a href="/login">click here</a> to login</p>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


    </div>

</div>
</main>



@endsection
@section('scripts')


    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>

<script type="text/javascript">
$(document).ready(function() {
  //setup before functions
var typingTimer;                //timer identifier
var doneTypingInterval = 5000;  //time in ms (5 seconds)

//on keyup, start the countdown
$('#email').keyup(function(){

    $('.email-error').html('Validating.....');
    clearTimeout(typingTimer);
    if ($('#email').val()) {
        typingTimer = setTimeout(doneTyping, doneTypingInterval);
    }
});


$('#phone').keyup(function(){

    $('.phone-error').html('Validating.....');
    clearTimeout(typingTimer);
    if ($('#phone').val()) {
        typingTimer = setTimeout(doneTyping3, doneTypingInterval);
    }
});





$('#password_confirmation').keyup(function(){
    $('.password-error').html('Confirming.....');
    clearTimeout(typingTimer);
    if ($('#password_confirmation').val()) {
        typingTimer = setTimeout(doneTyping2, doneTypingInterval);
    }
});

function doneTyping2 ()
{
  var password=$('#password').val();
  var password_confirmation=$('#password_confirmation').val();
  if(password != password_confirmation)
  {
    $('.password-error').html('password does not match');
    $('#password').val('');
    $('#password_confirmation').val('');
  }
  else {
    if(password.length<8)
    {
      $('#password').val('');
      $('#password_confirmation').val('');
       $('.password-error').html('password should have atleast 8 charcters');
    }
  else{

     $('.password-error').html('password successfuly confirmed');
       var email = $('#email').val();
     if(email.length > 0)
     {
       $( "#next" ).prop( "disabled", false );
     }
  }
  }
}
//user is "finished typing," do something
function doneTyping () {
  var email = $('#email').val();
  //alert(email);

  $.ajax({
      url:"/validation/email",
      type:"get",
      data:{'email':email},
      }).done(function (data) {
        if(email = '')
        {
        $('.email-error').css('display','none');

        }
        else {

              $('.email-error').html(data);
              if(data=='Email validation successful')
              {
                  $('#submit').prop('disabled',false);
                  $('#phone').removeAttr('disabled');
              }
        }

  }).fail(function () {
    $('.email-error').css('display','none');
    alert('enter a valid email address');
  });
}

function doneTyping3 () {
  var phone = $('#phone').val();
  //alert(email);
if(phone.length ==10)
{
  $.ajax({
      url:"/validation/phone",
      type:"get",
      data:{'phone':phone},
      }).done(function (data) {
        if(phone = '')
        {
        $('.phone-error').css('display','none');

        }
        else {

              $('.phone-error').html(data);
        }

  }).fail(function () {
    $('.phone-error').css('display','none');
    alert('enter a valid phone number');
  });
}

else
{
   $('.phone-error').html('Enter a valid phone number starting with 07 or 01');
}


}





});

</script>


<script>
    //-----------------
    $(document).ready(function(){
    $('#submit').click(function(e){
       e.preventDefault();
       /*Ajax Request Header setup*/
       $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
      });

       $('#submit').html('Sending..');

       /* Submit form data using ajax*/
      /*
       $.ajax({
          url: "/register/user",
          method: 'post',
          data: $('#msRegister').serialize(),

          success: function(response){
             //------------------------
                $('#submit').html('Submit');

                $('.success').html('Thank you for creating an account with us!!!');

              setTimeout(function () {
                window.location = '/userdashboard';
              }, 3000);

             //--------------------------
          },error: function(response) {
             $('#submit').html('Retry');
            $('.success').html('Ooops!!!Something went wrong please try again');
            /*
            setTimeout(function () {
              location.reload(true);
            }, 10000);
            */

}});
*/
       });
    });
    //-----------------
    </script>


@endsection
