<!-- resources/views/counties/index.blade.php -->

@extends('admin.layouts.admin-layout') <!-- Assuming you have a layout file -->

@section('content')
<div class="container">
    <div class="row mb-3">
        <div class="col-md-6">
            <a href="{{ route('admin.counties.create') }}" class="btn btn-primary">Add County</a>
        </div>
        <div class="col-md-6">
            @include('partials._message_box')
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>County Name</th>
                        <th>Country Code</th>
                        <th>Country</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($counties as $county)
                    <tr>
                        <td>{{ $county->id }}</td>
                        <td>{{ $county->county_name }}</td>
                        <td>{{ $county->county_no }}</td>
                        <td>{{ $county->country }}</td>
                        <td>
                            <a href="{{ route('admin.counties.edit', $county->id) }}" class="btn btn-primary btn-sm">Edit</a>
                            <form action="{{ route('admin.counties.destroy', $county->id) }}" method="POST" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this county?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
