@extends('layouts.landlord-layout')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="row">
            <div class="col-md-4">
                <h2>Checkout</h2>
            </div>
            <div class="col-md-8 justify-content-center">
                @include('partials._message_box')
            </div>
        </div>
    </div>


<div class="card">
    <form method="POST" action="{{ route('licenses.process-payment') }}">
        @csrf
        <input type="hidden" name="license_type" value="{{ $selectedLicenseType }} {{ old('confirm_terms') ? 'checked' : '' }} required">
                <!-- Add other hidden fields as needed -->

        <div class="row">
            <div class="col-md-6">

                        <div class="card-header">
                            <h5>You have selected the <strong>{{ $selectedLicenseType }}</strong> License.</h5>
                        </div>
                <div class="card-body">


                                    @if (is_array($licenseDetails))
                        <p><strong>License Features:</strong></p>
                        <ul>
                        @foreach ($licenseDetails as $detail)
                            <li>{!! $detail !!}</li>
                        @endforeach
                        </ul>
                        @else
                        <li>{{ $licenseDetails }}</li>
                        @endif

                    <p>Please confirm your purchase and select a payment method.</p>

                        <label for="confirmTerms">
                            <input type="checkbox" id="confirmTerms" name="confirm_terms" required>
                            I confirm that I have read and agree to the license terms.
                        </label>
                </div>
            </div>


            <div class="col-md-6">
                <div class="card-header">
                    <h5>Select Payment Method:</h5>
                </div>

                <div class="card-body">
                    <div class="payment-option">
                        <input type="radio" id="paypal" name="payment_method" value="paypal" required>
                        <label for="paypal">
                            <div class="payment-box">
                                <img src="{{ asset('storage/payment_gateway_logo/paypal.png') }}" alt="PayPal">
                            </div>
                        </label>
                    </div>

                    <div class="payment-option">
                        <input type="radio" id="visa" name="payment_method" value="visa" required>
                        <label for="visa">
                            <div class="payment-box">
                                <img src="{{ asset('storage/payment_gateway_logo/visa.png') }}" alt="Visa">
                            </div>
                        </label>
                    </div>

                    <div class="payment-option">
                        <input type="radio" id="cryptocurrency" name="payment_method" value="cryptocurrency" required>
                        <label for="cryptocurrency">
                            <div class="payment-box">
                                <img src="{{ asset('path/to/cryptocurrency-icon.png') }}" alt="Cryptocurrency">
                            </div>
                        </label>
                    </div>

                    <div class="payment-option">
                        <input type="radio" id="m-pesa" name="payment_method" value="m-pesa" required>
                        <label for="m-pesa">
                            <div class="payment-box">
                                <img src="{{ asset('storage/payment_gateway_logo/mpesa-imarket.png') }}" alt="m-pesa">
                            </div>
                        </label>
                    </div>
                    <div class="payment-option">
                        <input type="radio" id="airtel-money" name="payment_method" value="airtel-money" required>
                        <label for="airtel-money">
                            <div class="payment-box">
                                <img src="{{ asset('storage/payment_gateway_logo/Airtel-money.png') }}" alt="airtel-money">
                            </div>
                        </label>
                    </div>
                </div>
                    <!-- Add other payment method options -->
                    <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Process Payment</button>

                    </div>
            </div>

        </div>
</form>
</div>


<style>
    .payment-option {
        margin-bottom: 10px;
    }

    .payment-box {
        background-color: #f0f0f0; /* Set your desired background color */
        padding: 10px;
        border-radius: 5px;
        text-align: center;
    }

    .payment-box img {
        max-width: 100px; /* Set your desired max width for the payment method icon */
    }
</style>
</div>
</div>

@endsection

