@extends('layouts.apartment-layout')

@section('content')
    {{-- <div id="app">
        <invoices-section :tenant-invoices="{{ json_encode($tenantInvoices) }}" :apartment="{{ json_encode($apartment) }}"
            :user="{{ json_encode($user) }}" :compounded-balance="{{ $compoundedBalance }}"
            :routes="{{ json_encode([
                'invoices_edit' => route('invoices.edit', ['apartment' => $apartment->id, 'invoice' => '__invoiceId__']),
            ]) }}">
        </invoices-section>
    </div> --}}
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-4">
                        <h1 class="m-0">{{ $invoice->invoice_number }}</h1>


                    </div><!-- /.col -->
                    <div class="col-sm-4">
                        <div>
                            @include('partials._message_box')
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item"><a
                                    href="{{ route('landlord.apartment-this-month-invoices', $apartment->id) }}">ThisMonthInvoices</a>
                            </li>
                            <li class="breadcrumb-item active"># {{ $invoice->invoice_number }}</li>
                        </ol>
                    </div>
                    <!-- /.col -->
                </div><!-- /.row -->

            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <!-- invoice-header -->
        <div class="container-fluid">
            <div class="">
                <div class="card md-10">
                    <div class="card-header">
                        <div class="outer-box-button">
                            <a type="button" class="btn btn-primary" data-toggle="modal" data-target="#invoiceSection">
                                Summary</a>
                            <a type="button" class="btn btn-primary" data-toggle="modal" data-target="#addPaymentModal">
                                Add Payment</a>
                            <a type="button" class="btn btn-primary" data-toggle="modal" data-target="#optionSection">
                                Options</a>
                            <a type="button" class="btn btn-primary" data-toggle="modal" data-target="#creditSection">
                                Credit</a>
                            <a type="button" class="btn btn-primary" data-toggle="modal" data-target="#refundSection">
                                Refund</a>


                        </div>
                    </div>
                    <div class="card-body">
                        <div class="inner-box">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="center">
                                        <!-- Left Item -->



                                        <div class="name-date-box">
                                            <div class="form-group">
                                                <span class="label">Client Name:</span>
                                                <span class="">
                                                    <a
                                                        href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $user->id]) }}">
                                                        {{ $user->surname . $user->last_name }}
                                                    </a>
                                                    (<a href="">View Invoices</a>)
                                                </span>
                                            </div>

                                            <div class="form-group ">
                                                <span class="label "> Invoice Date:</span>
                                                <span class="">{{ $invoice->created_at }}</span>
                                            </div>
                                            <div class="form-group ">
                                                <span class="label "> Due Date:</span>
                                                <span class="">{{ $invoice->due_date }}</span>
                                            </div>
                                            <div class="form-group ">
                                                <span class="label ">Total Amount:</span>
                                                <span class="">{{ $apartment->currency }}
                                                    {{ number_format($invoice->total_amount, 2) }}</span>
                                            </div>
                                            <div class="form-group ">
                                                <span class="label ">Amount Paid:</span>
                                                <span class="">{{ $apartment->currency }}
                                                    {{ number_format($invoice->amount_paid, 2) }}</span>
                                            </div>
                                            <div class="form-group ">
                                                <span class="label ">Date:</span>
                                                <span class="">September 15, 2023</span>
                                            </div>
                                            <div class="form-group ">
                                                <span class="label ">Balance:</span>
                                                <span class="">{{ $apartment->currency }}
                                                    {{ $invoice->total_amount - $invoice->amount_paid }}</span>
                                            </div>




                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Right Item -->
                                    <div class="col box">
                                        <div class="item-box box">
                                            <div class="name-date-box">
                                                <span class="label inline"></span>
                                                <span
                                                    class="content inline text-uppercase {{ $invoice->payment_status }}"><strong>
                                                        <h2>{{ $invoice->payment_status }}</h2></span></strong>
                                                <span class="label inline">Payment Method:</span>
                                                <span class="center"> @include('partials._invoice_email_dropdown')</span>
                                                <!-- Add a line break to separate Name and Date -->
                                                <span class="label inline">Date:</span>
                                                <span class="content inline">{{ $invoice->updated_at }}</span><br>
                                                <span class="label inline">Payment Method:</span>
                                                <span class="content inline">{{ $invoice->payment_method }}</span><br>
                                                <!-- Buttons for marking invoices -->
                                                <form
                                                    action="{{ route('invoice.markStatus', ['invoice' => $invoice->id]) }}"
                                                    method="POST">
                                                    @csrf

                                                    <!-- Mark as Paid Button -->
                                                    <button type="submit" name="status" value="paid"
                                                        class="btn btn-success">Mark as Paid</button>

                                                    <!-- Mark as Unpaid Button -->
                                                    <button type="submit" name="status" value="unpaid"
                                                        class="btn btn-warning">Mark as Unpaid</button>

                                                    <!-- Cancel Invoice Button -->
                                                    <button type="submit" name="status" value="canceled"
                                                        class="btn btn-danger">Cancel Invoice</button>
                                                    <button type="submit" name="status" value="Partial">Mark as
                                                        Partial</button>
                                                </form>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Button to open the Add Payment modal -->

            </div>

            <div class="outer-box">

                <section>
                    <!--Invoice items-->
                    <div>

                        <h2>Invoice Items</h2>

                        <div>
                            <div class="card">
                                <div class="card-body">
                                    <form method="POST" action="{{ route('invoices.update', $invoice->id) }}">
                                        @csrf
                                        @method('PATCH')
                                        <form method="POST" action="{{ route('invoices.update', $invoice->id) }}">
                                            @csrf
                                            @method('PATCH')
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 1rem;"></th>
                                                        <th>Description</th>
                                                        <th>Total Amount</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if ($invoice->invoice_items)
                                                        @php
                                                            $formattedItems = [];
                                                            $decodedItems = json_decode($invoice->invoice_items, true);

                                                            // Define the desired order of items
                                                            $itemOrder = ['Apartment Name', 'Room Number', 'Month'];

                                                            // Check if json_decode was successful and it's an array
if (is_array($decodedItems)) {
    // Iterate through the desired order
    foreach ($itemOrder as $desiredItem) {
        // Check if the item exists in the decoded data
        $matchingItem = collect($decodedItems)->first(
            function ($item) use ($desiredItem) {
                return is_array($item) &&
                    isset($item['item'], $item['value']) &&
                    $item['item'] === $desiredItem;
            },
        );

        // If a matching item is found, add its value to the formatted items
        if ($matchingItem) {
            switch ($desiredItem) {
                case 'Room Number':
                    $formattedItems[] =
                        'Room Number: ' .
                        $matchingItem['value'];
                    break;
                default:
                    $formattedItems[] =
                        $matchingItem['value'];
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        @endphp
                                                        <tr>
                                                            <td>
                                                                <input type="checkbox" class="invoiceCheckbox"
                                                                    data-invoice-id="{{ $invoice->id }}"
                                                                    data-invoice-id="{{ $invoice->id }}">
                                                            </td>
                                                            <td>
                                                                <textarea name="invoice_items" class="form-control" rows="1" cols="40">
                                                                            {{ implode(' - ', $formattedItems) }}
                                                                        </textarea>
                                                            </td>
                                                            <td style="white-space: nowrap;">{{ $apartment->currency }}
                                                                <input type="text" name="total_amount"
                                                                    value="{{ $invoice->total_amount }}"
                                                                    style="width: 100px;" />
                                                            </td>
                                                        </tr>
                                                    @endif
                                                    <!-- Add a row with a blank textarea for adding another field data -->
                                                    <tr>
                                                        <td>
                                                            <input type="checkbox" class="invoiceCheckbox"
                                                                data-invoice-id="{{ $invoice->id }}"
                                                                data-invoice-id="{{ $invoice->id }}">
                                                        </td>
                                                        <td>
                                                            <textarea name="new_invoice_item" class="form-control" rows="1" cols="40"></textarea>
                                                        </td>
                                                        <td style="white-space: nowrap;">{{ $apartment->currency }} <input
                                                                type="text" name="new_total_amount" value=""
                                                                style="width: 100px;" /></td>


                                                    </tr>
                                                </tbody>
                                            </table>

                                        </form>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-success">Save Changes</button>
                                    <button type="button" class="btn btn-danger" id="cancelChanges">Cancel
                                        Changes</button>
                                </div>
                            </div>


                        </div>
                    </div>
                </section>
            </div>
        </div>
        <!-- Transactions items -->
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <h2>Transactions</h2>

                    @if (!empty($invoice->payments) && is_array(json_decode($invoice->payments, true)))
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Payment Method</th>
                                    <th>Transaction ID</th>
                                    <th>Amount</th>
                                    <th>Transaction Fee</th>
                                    <th><input type="checkbox" id="selectAll" onchange="toggleCheckboxes()"></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (json_decode($invoice->payments, true) as $transaction)
                                    <tr>
                                        <td>{{ $transaction['payment_date'] }}</td>
                                        <td>{{ $transaction['payment_method'] }}</td>
                                        <td>{{ $transaction['transaction_id'] }}</td>
                                        <td>{{ $transaction['payment_amount'] }}</td>
                                        <td>{{ $transaction['transaction_fee'] }}</td>
                                        <td><input type="checkbox" class="transaction-checkbox"
                                                data-transaction-index="{{ $loop->index }}"></td>

                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p>No transactions available.</p>
                    @endif
                </div>
            </div>
            <button onclick="performAction()">Perform Action on Selected Items</button>
            <button onclick="deleteSelected()">Delete Selected Items</button>
        </div>


        <!--/Transaction items--->
    </div><!--/Content Wrapper--->



    <!-- Add Payment Modal -->
    <div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog" aria-labelledby="addPaymentModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addPaymentModalLabel">Add Payment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div id="paymentResponseMessage"></div> <!-- Response message container -->
                <div class="modal-body">
                    <form action="{{ route('invoice.addPayment', $invoice->id) }}" method="POST">
                        @csrf
                        <!-- Payment Date -->
                        <div class="form-group">
                            <label for="payment_date">Payment Date</label>
                            <input type="date" class="form-control" id="payment_date" name="payment_date">
                        </div>
                        <!-- Payment Method -->
                        <div class="form-group">
                            <label for="payment_method">Payment Method</label>
                            <input type="text" class="form-control" id="payment_method" name="payment_method">
                        </div>
                        <!-- Transaction ID -->
                        <div class="form-group">
                            <label for="transaction_id">Transaction ID</label>
                            <input type="text" class="form-control" id="transaction_id" name="transaction_id">
                        </div>
                        <!-- Amount -->
                        <div class="form-group">
                            <label for="amount">Amount</label>
                            <input type="text" class="form-control" id="payment_amount" name="payment_amount">
                        </div>
                        <!-- Transaction Fee -->
                        <div class="form-group">
                            <label for="transaction_fee">Transaction Fee</label>
                            <input type="text" class="form-control" id="transaction_fee" name="transaction_fee">
                        </div>
                        <button type="submit" class="btn btn-primary">Add Payment</button>
                    </form>
                </div>
            </div>
        </div>
    </div>





@endsection
