@extends('layouts.tenant-profile-layout')

@section('content')
<style>
    .section-links {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
}

.section-link {
    display: inline-block;
    padding: 10px 20px;
    background-color: #f0f0f0;
    border: 1px solid #ccc;
    border-radius: 5px;
    text-decoration: none;
    color: #333;
    font-weight: bold;
}

.section-link:hover {
    background-color: #b2bbf3;
}
.section-link:active {
    background-color: #b2bbf3;
}
.content-section {
    font-size: 14px;
        padding: 2px;
}
.content-section form input,
    .content-section form select,
    .content-section form textarea {
        font-size: 10px;
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            @include('partials._tenant_dropdown')
          </div>
          <div class="col-sm-3">

          </div>
          <div class="col-sm-3">
            {{-- <!-- Display user avatar -->
           <img class="rounded-circle fixed" width="150px"

            src="{{ asset('storage/' . $user->profile_picture) }}" alt="Tenant Avatar"><span class="text-black-50">{{$user->phone_number}}</span> --}}
          </div>
        </div>
      </div>

      <summary-section :tenant-id="{{ $tenant->id }}" :tenant-name="{{ $tenant->first_name }}"></summary-section>

        <div class="sections links button-container centered" >

            <a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}?section=summary-section" class="section-link my-button" id="summary-link">Summary</a>
            <a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}?section=profile-section" class="section-link nav-btn my-button" id="profile-link">Profile</a>
            <!-- Add more links for other sections as needed -->

            <a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#summary-section" data-section="summary-section"    class="section-link  my-button" id="summary-link">Summary</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#profile-section"  data-section="profile-section"    class="section-link  nav-btn my-button" id="profile-link">Profile</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#users-section" data-section="users-section"    class="section-link  nav-btn my-button" id="users-link">Users</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#contacts-section" data-section="contacts-section"  class="section-link  nav-btn my-button">Contacts</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#products-section" data-section="products-section"  class="section-link  nav-btn my-button">Services</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#rooms-section"  data-section="rooms-section" class="section-link  nav-btn my-button">Rooms</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#invoices-section" data-section="invoices-section"  class="section-link  nav-btn my-button">Invoices</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#transactions-section"  data-section="transactions-section" class="section-link  nav-btn my-button">Transactions</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#tickets-section" data-section="tickets-section" class="section-link nav-btn my-button">Tickets</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#emails-section" data-section="emails-section" class="section-link nav-btn my-button">Emails</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#notes-section" data-section="notes-section" class="section-link nav-btn my-button">Notes</a>
<a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment, 'usersInApartment' => $user->id]) }}#logs-section" data-section="logs-section" class="section-link nav-btn my-button">Log</a>

        </div>
    </div>


    <!-- Content Sections -->
    @include('partials._message_box')
    <div id="summary-section" class="content-section">


        <!-- Outer container for the entire profile section -->
        <div class="outer-box">
                    <!-- Inner container for profile heading -->
                    <div class="inner-box">
                        <h5>#{{$tenant->id}}-{{$tenant->first_name}}</h5>
                    </div>

                                    <!-- Inner container for user information -->
                            <div class="inner-box user-info-container">
                                <div class="row">
                                    <div class="col-lg-3 profile-list-contaner inner-box">
                                        <h6>Clients Information</h6>
                                        <div class="row">
                                            <ul>
                                                <li><strong>First Name:</strong> {{$user->first_name}}</li>
                                                <li><strong>Last Name:</strong> {{$user->last_name}}</li>
                                                <li>Email Address:{{$user->email}}</li>
                                                <li>Address 1 {{$user->address_1}}</li>
                                                <li>Address 2 {{$user->address_2}}</li>
                                                <li>City {{$user->city}}</li>
                                                <li>State/Region</li>
                                                <li>Country {{$user->country}}</li>
                                                <li>Phone Number {{$user->phone_number}}</li>
                                            </ul>


                                        </div>
                                        <h6>Send User SMS</h6>
                                        <div class="row">


                                                Reports

                                        </div>
                                    </div>
                                    <div class="col-lg-3 profile-list-contaner inner-box">

                                        <h6>Invoices/Billing</h6>
                                        <div class="row">
                                            <ul>
                                                <li><strong>Paid:</strong> {{$user->first_name}}</li>
                                                <li><strong>Draft:</strong> {{$user->last_name}}</li>
                                                <li>Due:{{$user->email}}</li>
                                                <li>Cancelled {{$user->address_1}}</li>
                                                <li>Refunded {{$user->address_2}}</li>
                                                <li>Collections {{$user->city}}</li>
                                                <li>Credit Balance</li>
                                                <li>Deposit{{$user->country}}</li>
                                                <li>Phone Number {{$user->phone_number}}</li>
                                            </ul>


                                        </div>
                                    </div>
                                    <div class="col-lg-3 profile-list-cntainer inner-box">
                                        <h6>Products/Service</h6>
                                        <div class="row">
                                            <ul>
                                                <li><strong>Room:</strong> {{$user->first_name}}</li>
                                                <li><strong>Draft:</strong> {{$user->last_name}}</li>
                                                <li>Due:{{$user->email}}</li>
                                                <li>Cancelled {{$user->address_1}}</li>
                                                <li>Refunded {{$user->address_2}}</li>
                                                <li>Collections {{$user->city}}</li>
                                                <li>Credit Balance</li>
                                                <li>Deposit{{$user->country}}</li>
                                                <li>Affiliate Signups {{$user->phone_number}}</li>
                                            </ul>


                                        </div>
                                        <div class="row">
                                            <div class="inner-box">
                                                <h6>Services</h6>
                                                <table>

                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-lg-3 profile-list-conainer inner-box">
                                        <h6>Other Actions</h6>
                                        Reports
                                    </div>
                                </div>
                            </div>


                                <div class="inner-box">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="main-box clearfi">
                                                <div class="table-responsive">
                                                    <h6>Rooms</h6>
                                                    <table>
                                                        <tr>
                                                            <th>Room No</th>

                                                            <th>Amount</th>
                                                            <th>Billing Cycle</th>
                                                            <th>Signup Date</th>
                                                            <th>Next Due Date</th>
                                                            <th>Status</th>
                                                        </tr>
                                                        <tbody>
                                                            @if($tenantRooms->isNotEmpty())
                                                            @foreach ($tenantRooms as $room)
                                                                <tr>
                                                                    <td>{{ $room->room_number }}</td>
                                                                    <td>{{ $apartment->currency }}{{ $room->price }}</td>
                                                                    <td>{{ $room->billing_cycle }}</td>
                                                                    <td>{{-- Fill with appropriate data related to the room --}}</td>
                                                                    <td>{{-- Fill with appropriate data related to the room --}}</td>
                                                                    <td>{{ $room->status }}</td>
                                                                </tr>
                                                            @endforeach
                                                        @else
                                                            <tr>
                                                                <td colspan="6">No rooms assigned</td>
                                                            </tr>
                                                        @endif
                                                        </tbody>
                                                    </table>
                                                </div>
                                                        <div class="table-responsive">
                                                            <h6>Services</h6>
                                                            <table>
                                                                <tr>
                                                                    <th>ID</th>
                                                                    <th>Services</th>
                                                                    <th>Amount</th>
                                                                    <th>Billing Cycle</th>
                                                                    <th>Signup Date</th>
                                                                    <th>Next Due Date</th>
                                                                    <th>Status</th>
                                                                </tr>
                                                                <tbody>

                                                                    @if(isset($room))
                                                                        <tr>
                                                                            <td>{{ $room->id }}</td>
                                                                            <td>Room</td>
                                                                            <td>{{$apartment->currency}}{{ $room->price }}</td>
                                                                            <td>{{ $room->billing_cycle }}</td>
                                                                            <td>{{-- Fill with appropriate data related to the room --}}</td>
                                                                            <td>{{-- Fill with appropriate data related to the room --}}</td>
                                                                            <td>{{ $room->status }}</td>
                                                                        </tr>
                                                                    @endif

                                                                    @forelse ($tenantservices as $service)
                                                                        <tr>
                                                                            <td>{{ $service->id }}</td>
                                                                            <td>{{ $service->name }}</td> <!-- Assuming you have a 'name' column in your services table -->
                                                                            <td>{{ $service->pivot->amount }}</td> <!-- Access pivot attribute for amount -->
                                                                            <td>{{ $service->pivot->billing_cycle }}</td> <!-- Access pivot attribute for billing cycle -->
                                                                            <td>{{ $service->pivot->signup_date->format('Y-m-d') }}</td> <!-- Access pivot attribute for created_at -->
                                                                            <td>{{ $service->pivot->next_due_date->format('Y-m-d') }}</td> <!-- Access pivot attribute for next_due_date -->
                                                                            <td>{{ $service->pivot->status }}</td> <!-- Access pivot attribute for status -->
                                                                        </tr>
                                                                    @empty
                                                                    @if(empty($tenantservices) && !isset($room))
                                                                    <tr>
                                                                        <td colspan="7">No services subscribed</td>
                                                                    </tr>
                                                                @endif
                                                                    @endforelse
                                                                </tbody>

                                                            </table>
                                                        </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>



                    <!-- Container for Save and Cancel buttons -->
                    <div class="button-container">
                        <!-- Buttons --><!-- Add a click event to the Save button -->
                        <button type="button" onclick="saveTenantSummary({{ $apartment->id }}, {{ $user->id }})" class="btn btn-primary button-medium-wide">Save Changes</button>
                        <button type="button" onclick="cancelTenantSummaryChanges()" class="btn btn-secondary button-medium-wide">Cancel</button>
                    </div>
                </div>
    </div>


    <div id="profile-section" class="content-section">


        <!-- Outer container for the entire profile section -->
        <div class="outer-box">
                    <!-- Inner container for profile heading -->
                    <div class="inner-box">
                        <div class="row">
                            <div class="col-md-4">
                                <h5>Profile</h5>
                            </div>
                            <div class="col-md-4">

                            </div>
                            <div class="col-md-4">
                                <span>
                                    <div class="form-group">
                                        <div class="label">Role:</div><strong>
                                        <!-- Display user roles for each apartment -->
                                            @foreach($user->apartments as $apartment)
                                            <h6>{{ $apartment->pivot->role }}</h6>
                                            @endforeach
                                        </strong>
                                    </div>
                                </span>
                            </div>
                        </div>

                    </div>

                                    <!-- Inner container for user information -->
                            <div class="inner-box user-info-container">
                                        <form id="profileForm">
                                            @csrf
                                    <div class="row ">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="label"for="firstName" class="col-sm-4 col-form-label text-right">First Name:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="firstName" name="firstName" value="{{ $user->first_name }}" required class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="lastName" class="col-sm-4 col-form-label text-right">Last Name:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="lastName" name="lastName" value="{{ $user->last_name }}" required class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="idNumber" class="col-sm-4 col-form-label text-right">ID Number:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="idNumber" name="idNumber" value="{{ $user->id_number }}" required class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="idNumber" class="col-sm-4 col-form-label text-right">Last Name:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="idNumber" name="idNumber" value="{{ $user->last_name }}" required class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="label"for="email" class="col-sm-4 col-form-label text-right">Email:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="email" id="email" name="email" value="{{ $user->email }}" required class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="address" class="col-sm-4 col-form-label text-right">Phone:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="address" name="address" value="{{ $user->phone_number }}" class="form-control">
                                                </div>
                                            </div>

                                            <!-- Add more fields as needed -->
                                        </div>

                                        <div class="col-md-6">


                                            <div class="form-group ">
                                                <label class="label"for="address" class="col-sm-4 col-form-label text-right">Country:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="address" name="address" value="{{ $user->address }}" class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="address" class="col-sm-4 col-form-label text-right">County:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="address" name="address" value="{{ $user->county }}" class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="email" class="col-sm-4 col-form-label text-right">Email:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="email" id="email" name="email" value="{{ $user->email }}" required class="form-control">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="label"for="address" class="col-sm-4 col-form-label text-right">Phone:</label>
                                                <div class="col-sm-8">
                                                    <input class="content" type="text" id="address" name="address" value="{{ $user->phone_number }}" class="form-control">
                                                </div>
                                            </div>
                                            <!-- Add more fields as needed -->
                                        </div>

                                    </div>

                                    <!-- Email Notification Checkboxes -->
                                    <div class="form-group ">
                                        <label class="label"for="address" class="col-sm-2 col-form-label text-right">Email Notifications:</label>
                                        <div class="col-sm-10">
                                            <div class="checkbox-container">
                                                <div class="form-check">
                                                    <input class="content" type="checkbox" id="service1" name="service1" class="form-check-input" {{ $user->emailService1 ? 'checked' : '' }}>
                                                    <label class="label" class="form-check-label" for="service1">Available rooms notification</label>
                                                </div>
                                            </div>

                                            <div class="checkbox-container">
                                                <div class="form-check">
                                                    <input class="content" type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                                    <label class="label"class="form-check-label" for="service2">New Invoices Generated</label>
                                                </div>
                                            </div>
                                            <div class="checkbox-container">
                                                <div class="form-check">
                                                    <input class="content" type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="service2">New Invoices Generated</label>
                                                </div>
                                            </div>
                                            <div class="checkbox-container">
                                                <div class="form-check">
                                                    <input class="content" type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="service2">New Invoices Generated</label>
                                                </div>
                                            </div>
                                            <div class="checkbox-container">
                                                <div class="form-check">
                                                    <input class="content" type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="service2">New Invoices Generated</label>
                                                </div>
                                            </div>
                                            <!-- Add more checkboxes and labels as needed -->
                                        </div>
                                    </div>
                                        </form>
                            </div>

                    <!-- Container for Save and Cancel buttons -->
                    <div class="button-container">
                        <!-- Buttons --><!-- Add a click event to the Save button -->
                        <button type="button" onclick="saveTenantProfile({{ $apartment->id }}, {{ $user->id }})" class="btn btn-primary">Save</button>
                        <button type="button" onclick="cancelTenantProfileChanges()" class="btn btn-secondary">Cancel</button>
                    </div>
                    </div>
    </div>



    <div id="users-section" class="content-section">



            <!-- Outer container for the entire profile section -->
            <div class="outer-box">
                <!-- Inner container for profile heading -->
                <div class="inner-box">
                    <h5>User</h5>
                </div>

                <!-- Inner container for user information -->
                <div class="inner-box user-info-container">
                    <form id="UserForm">
                        @csrf
                <div class="row ">
                    <div class="col-md-6">
                        <div class="form-group row">
                            <label for="firstNadme" class="col-sm-4 col-form-label text-right">First Name:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="firsdtName" name="firstdName" value="{{ $user->first_name }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="idNumber" class="col-sm-4 col-form-label text-right">Last Name:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="idNumber" name="lastNdame" value="{{ $user->last_name }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="idNumber" class="col-sm-4 col-form-label text-right">ID Number:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="idNumber" name="idNdumber" value="{{ $user->id_number }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="idNumber" class="col-sm-4 col-form-label text-right">Last Name:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="lastNam" name="lastdNam" value="{{ $user->last_name }}" required class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="email" class="col-sm-4 col-form-label text-right">Email:</label>
                            <div class="col-sm-8">
                                <input class="content" type="email" id="email" name="email" value="{{ $user->email }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="address" class="col-sm-4 col-form-label text-right">Phone:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="address" name="address" value="{{ $user->phone_number }}" class="form-control">
                            </div>
                        </div>

                        <!-- Add more fields as needed -->
                    </div>

                    <div class="col-md-6">


                        <div class="form-group row">
                            <label for="address" class="col-sm-4 col-form-label text-right">Country:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="address" name="address" value="{{ $user->address }}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="address" class="col-sm-4 col-form-label text-right">County:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="address" name="address" value="{{ $user->county }}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="email" class="col-sm-4 col-form-label text-right">Email:</label>
                            <div class="col-sm-8">
                                <input class="content" type="email" id="email" name="email" value="{{ $user->email }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="address" class="col-sm-4 col-form-label text-right">Phone:</label>
                            <div class="col-sm-8">
                                <input class="content" type="text" id="address" name="address" value="{{ $user->phone_number }}" class="form-control">
                            </div>
                        </div>
                        <!-- Add more fields as needed -->
                    </div>

                </div>

                <!-- Email Notification Checkboxes -->
                <div class="form-group row align-items-center">
                    <label for="address" class="col-sm-2 col-form-label text-right">Email Notifications:</label>
                    <div class="col-sm-10">
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input class="content" type="checkbox" id="service1" name="service1" class="form-check-input" {{ $user->emailService1 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service1">Available rooms notification</label>
                            </div>
                        </div>

                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <!-- Add more checkboxes and labels as needed -->
                    </div>
                </div>



                <!-- Admin Notes -->
                <div class="form-group">
                    <label for="adminNotes">Admin Notes:</label>
                    <textarea id="adminNotes" name="adminNotes" rows="4">{{ $user->adminNotes }}</textarea>
                </div>

            </form>
        </div>

        <!-- Container for Save and Cancel buttons -->
        {{-- <div class="button-container">
            <!-- Buttons --><!-- Add a click event to the Save button -->
            <button type="button"  class="btn btn-primary">Save</button>
            <button type="button"  class="btn btn-secondary">Cancel</button>
        </div> --}}
        </div>
    </div>




        <div id="contacts-section" class="content-section">
            <h2>Contacts</h2>
            <!-- Content for the Contacts section goes here -->
        </div>

        <div id="products-section" class="content-section">
            <h2>Services</h2>
            <!-- Content for the Products section goes here -->
        </div>

        <div id="rooms-section" class="content-section">



            <!-- Outer container for the entire profile section -->
            <div class="outer-box">
                <!-- Inner container for profile heading -->
                <div class="inner-box">
                    <div class="row">
                    <h6>Rooms</h6>
                    <button> Go to Room</button>
                </div>
                </div>

                <!-- Inner container for user information -->
                <div class="inner-box user-info-container">
                    <form id="UserForm">
                        @csrf
                <div class="row ">
                    <div class="col-md-6">
                        <div class="form-group row small-form">
                            <label for="firstNadme" class="col-sm-4 col-form-label text-right">Order #:</label>
                            <div class="col-sm-8">
                                <input type="text" id="firsdtName" name="firstdName" value="{{ $user->first_name }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row small-form">
                            <label for="idNumber" class="col-sm-4 col-form-label text-right">Order Type:</label>
                            <div class="col-sm-8">
                                <input type="text" id="idNumber" name="lastNdame" value="{{ $user->last_name }}" required class="form-control">
                            </div>
                        </div>
                        @foreach ($tenantRooms as $room )


                        <div class="form-group row small-form">
                            <label for="idNumber" class="col-sm-4 col-form-label text-right">Room Number:</label>
                            <div class="col-sm-8">
                                @if ($tenantRooms->isNotEmpty())
                                <select id="roomstatus" name="roomstatus" class="form-control">
                                    @foreach ($tenantRooms as $room)
                                        <option value="{{ $room->room_number }}">{{ $room->room_number }}</option>
                                    @endforeach
                                </select>
                            @else
                                <p>User does not have a room.</p>
                            @endif
                            </div>
                        </div>
                        @endforeach
                        <div class="form-group row small-form">
                            <label for="idNumber" class="col-sm-4 col-form-label text-right">First Payment:</label>
                            <div class="col-sm-8">
                                <input type="text" id="lastNam" name="lastdNam" value="{{ $user->last_name }}" required class="form-control">
                            </div>
                        </div>
                        <div class="form-group row small-form">
                            <label for="email" class="col-sm-4 col-form-label text-right">Recurring Payment:</label>
                            <div class="col-sm-8">
                                @if ($tenantRooms->isNotEmpty())
                                <select id="roomstatus" name="roomstatus" class="form-control">
                                    @foreach ($tenantRooms as $room)
                                        <option value="{{ $room->price }}">{{ $room->price }}</option>
                                    @endforeach
                                </select>
                            @else
                                <p>User does not have a room.</p>
                            @endif
                            </div>
                        </div>

                        <div class="form-group row small-form">
                            <label for="address" class="col-sm-4 col-form-label text-right">Room Type:</label>
                            <div class="col-sm-8">
                                @if ($tenantRooms->isNotEmpty())
                                <select id="roomstatus" name="roomstatus" class="form-control">
                                    @foreach ($tenantRooms as $room)
                                        <option value="{{ $room->room_size }}">{{ $room->room_size }}</option>
                                    @endforeach
                                </select>
                            @else
                                <p>User does not have a room.</p>
                            @endif
                            </div>
                        </div>



                        <div class="form-group row small-form">
                            <label for="roomstatus" class="col-sm-4 col-form-label text-right">Status:</label>
                            <div class="col-sm-8">
                                @if ($tenantRooms->isNotEmpty())
                                <select id="roomstatus" name="roomstatus" class="form-control">

                                    @foreach ($tenantRooms as $room)
                                        <option value="{{ $room->status }}">{{ $room->status }}</option>
                                    @endforeach
                                    <optgroup label="Available Status">
                                        @foreach ($availableStatuses as $status)
                                            <option value="{{ $status }}">{{ $status }}</option>
                                        @endforeach
                                    </optgroup>
                                </select>
                            @else
                                <p>User does not have a room.</p>
                            @endif
                        </div>
                        </div>


                        <!-- Add more fields as needed -->
                    </div>

                    <div class="col-md-6">


                        <div class="form-group row small-form">
                            <label for="address" class="col-sm-4 col-form-label text-right">Duration:</label>
                            <div class="col-sm-8">
                                <input type="text" id="address" name="address" value="{{ $user->creation_date }}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row small-form">
                            <label for="address" class="col-sm-4 col-form-label text-right">Tenant From:</label>
                            <div class="col-sm-8">
                                <input type="text" id="address" name="address" value="{{ $user->county }}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row small-form">
                            <label for="email" class="col-sm-4 col-form-label text-right">Expiry Date:</label>
                            <div class="col-sm-8">
                                <input type="email" id="email" name="email" value="{{ $user->email }}" required class="form-control">
                            </div>
                        </div>

                        <div class="form-group row small-form">
                            <label for="address" class="col-sm-4 col-form-label text-right">Next Due Date:</label>
                            <div class="col-sm-8">
                                <input type="text" id="address" name="address" value="{{ $user->name}}" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row small-form">
                            <label for="address" class="col-sm-4 col-form-label text-right">Payment Method:</label>
                            <div class="col-sm-8">
                                <input type="text" id="address" name="address" value="{{ $user->name}}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row small-form">
                            <label for="paymentstatus" class="col-sm-4 col-form-label text-right">Payment Status:</label>
                            <div class="col-sm-8">
                                <select id="paymentstatus" name="paymentstatus" class="form-control">
                                    <!-- Options will be dynamically added here -->
                                </select>
                            </div>
                        </div>

                        <!-- Add more fields as needed -->
                    </div>

                </div>

                <!-- Email Notification Checkboxes -->
                <div class="form-group row align-items-center">
                    <label for="address" class="col-sm-2 col-form-label text-right">Email Notifications:</label>
                    <div class="col-sm-10">
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service1" name="service1" class="form-check-input" {{ $user->emailService1 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service1">Available rooms notification</label>
                            </div>
                        </div>

                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <div class="checkbox-container">
                            <div class="form-check">
                                <input type="checkbox" id="service2" name="service2" class="form-check-input" {{ $user->emailService2 ? 'checked' : '' }}>
                                <label class="form-check-label" for="service2">New Invoices Generated</label>
                            </div>
                        </div>
                        <!-- Add more checkboxes and labels as needed -->
                    </div>
                </div>



                <!-- Admin Notes -->
                <div class="form-group">
                    <label for="adminNotes">Admin Notes:</label>
                    <textarea id="adminNotes" name="adminNotes" rows="4">{{ $user->adminNotes }}</textarea>
                </div>

            </form>
        </div>

        <!-- Container for Save and Cancel buttons -->
        {{-- <div class="button-container">
            <!-- Buttons --><!-- Add a click event to the Save button -->
            <button type="button"  class="btn btn-primary">Save</button>
            <button type="button"  class="btn btn-secondary">Cancel</button>
        </div> --}}
        </div>
    </div>

        <div id="invoices-section" class="content-section">
            <div class="outer-box">
                <div class="row">
                    <div class="col-md-3">
                        <h5>INVOICES</h5>
                    </div>
                    <div class="col-md-3">

                    </div>
                    <div class="col-md-3">
                        <h5>Balance:<strong>{{ $apartment->currency }}{{ number_format($compoundedBalance, 2) }}</h5>
                    </div>
                    <div class="col-md-3 button-container ">

                        <button class="button-secondary nav-btn my-button" onclick=""> Search</button>
                                            <!-- Button to create invoice -->
                    <form action="{{ route('create-invoice', ['apartment' => $apartment->id, 'user' => $user->id]) }}" method="post">
                        @csrf
                        <button type="submit" class="button-primary nav-btn my-button">Create Invoice</button>
                    </form>

                    </div>




                </div>

                <div class="row">
                <div id="message-section"></div>
            </div>
            <!-- Content for the Invoices section goes here -->

            <div class="inner-box user-info-container">
            <div class="row">

                <table class="table">
                    <thead>
                        <tr>
                           <th> <input type="checkbox" id="selectAllUserInvoices"> </th>
                            <th>Invoice #</th>

                            <th>Creation Date</th>
                            <th>Due Date</th>
                            <th>Total</th>
                            <th>Payment Method</th>

                            <th class="small-width">Status</th>
                            <th class="small-width">Edit</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($tenantInvoices as $invoice)
                            <tr>
                                <td class="small-width"><input type="checkbox" class="invoiceCheckbox" data-invoice-id="{{ $invoice->id }}"></td>
                                <td>
                                    <a href="{{ route('landlord-edit-invoice', ['apartment'=>$apartment->id, 'invoice' => $invoice->id]) }}">
                                        {{ $invoice->invoice_number }}
                                    </a>
                                </td>

                                <td >{{ $invoice->created_at }}</td>
                                <td><strong>{{ $invoice->due_date }} </strong></td>
                                <td>{{ $invoice->total_amount }}</td>
                                <td>Mpesa</td>
                                <td class="{{ $invoice->payment_status}}">
                                    {{ $invoice->payment_status }}
                                </td>
                                <td>Edit</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8">No invoices found</td>
                            </tr>
                        @endforelse

                    </tbody>

                </table>
                </div>
            </div>
                <div class="row">
                    <h6 class="">With selected:</h6>
                    <button class="nav-btn my-button button-secondary ">Mark Paid</button>
                    <button class="button-danger button-wide nav-btn my-button" onclick="">Mark Unpaid</button>
                    <button class="button-wide nav-btn my-button button-primary">Merge</button>
                    <button class="button-primary button-wide nav-btn my-button">Cancel</button>
                    <button class="button-secondary button-wide nav-btn my-button" onclick="confirmUserInvoiceMassPay()">Mass Pay</button>
                    <button class="button-wide nav-btn my-button button-danger" onclick="confirmUserInvoiceDelete()">Delete</button>
                </div>
         </div>
        </div>

        <div id="transactions-section" class="content-section">
            <h4>Transactions for {{ $user->name }}</h4>

@if ($transactions->isEmpty())
    <p>No transactions found for this user.</p>
@else
<table class="table" id="transaction-table">
    <thead>
        <tr>
            <th>Invoice Number</th>
            <th class="sort" data-sort="payment-date">Payment Date</th>
            <th>Payment Amount</th>
            <th>Payment Method</th>
            <th>Transaction ID</th>
            <th class="capitalize">Transaction Fee</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($transactions as $payment)
            <tr>
                <td>{{ $payment['invoice_number'] }}</td>
                <td class="payment-date">{{ $payment['payment_date'] }}</td>
                <td>{{ $payment['payment_amount'] }}</td>
                <td>{{ $payment['payment_method'] }}</td>
                <td class="capitalize">{{ $payment['transaction_id'] }}</td>
                <td>{{ $payment['transaction_fee'] }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
@endif
        </div>

        <div id="tickets-section" class="content-section">
            <h2>Tickets</h2>
            <!-- Content for the Tickets section goes here -->
        </div>



        <script>
            $(document).ready(function() {
                $('#transaction-table th.sort').click(function() {
                    var table = $(this).closest('table');
                    var rows = table.find('tbody tr').toArray().sort(comparator($(this).index()));
                    table.find('tbody').empty().append(rows);
                });

                function comparator(index) {
                    return function(a, b) {
                        var valA = $(a).find('td').eq(index).text();
                        var valB = $(b).find('td').eq(index).text();
                        if (index === 1) { // Column index for Payment Date
                            valA = new Date(valA);
                            valB = new Date(valB);
                        }
                        return valA > valB ? -1 : valA < valB ? 1 : 0; // Sort in descending order
                    };
                }
            });
        </script>

        <!-- JavaScript to handle scrolling to the desired section -->
<script>
    // Function to scroll to the section with the given ID
    function scrollToSection(sectionId) {
        // Get the offset of the section
        var sectionOffset = $('#' + sectionId).offset().top;
        // Scroll to the section with a smooth animation
        $('html, body').animate({
            scrollTop: sectionOffset
        }, 500);
    }

    // Event listeners for section links
    $(document).ready(function() {
        $('.section-link').on('click', function(event) {
            event.preventDefault(); // Prevent default link behavior
            var sectionId = $(this).attr('href').substring(1); // Get section ID from href attribute
            scrollToSection(sectionId); // Scroll to the section
        });
    });
</script>

{{-- <script>
    $(document).ready(function() {
        // Get the section name from the URL hash
        var section = window.location.hash.substring(1);

        // If the section name is not empty and exists in the document, show it
        if (section !== '' && $('#' + section).length > 0) {
            // Hide all sections first
            $('.content-section').hide();
            // Show the section corresponding to the hash
            $('#' + section).show();
        }
    });
</script> --}}

 <script>
     // Function to show a specific section
     function showSection(section) {
        // Hide all sections
        var sections = document.querySelectorAll('.section');
        sections.forEach(function (sec) {
            sec.style.display = 'none';
        });

        // Show the selected section
        document.getElementById(section).style.display = 'block';
    }

    // Show the default section on page load
    document.addEventListener('DOMContentLoaded', function () {
        showSection('summary-section');
    });

  // Function to highlight active section link and store active section in URL hash
function highlightActiveLink() {
    const sectionLinks = document.querySelectorAll('.section-link');

    // Loop through each section link
    sectionLinks.forEach(link => {
        const sectionId = link.getAttribute('href').substring(1);
        const section = document.getElementById(sectionId);

        // Check if the section is in the viewport
        if (section.getBoundingClientRect().top <= 0) {
            // Remove active class from all section links
            sectionLinks.forEach(l => l.classList.remove('active'));
            // Add active class to the current section link
            link.classList.add('active');
            // Store active section in URL hash
            window.location.hash = sectionId;
        }
    });
}

// Event listener for scrolling
window.addEventListener('scroll', highlightActiveLink);

// Initial call to highlight the active link
highlightActiveLink();

</script>

</body>
</div>
</html>
@endsection
