@extends('layouts.apartment-layout')

@section('content')
<style>
     /* Style for the container */
     .container-box {
        display: flex; /* Use flexbox to create a row layout */
        flex-direction: column; /* Stack boxes vertically */
        justify-content: space-between; /* Space between the two boxes */
        align-items: center; /* Center items horizontally within the container */
        width: 100%;
    }

    /* Style for the left and right boxes */
    .box {
        flex: 1; /* Equal width for both boxes */
        padding: 10px;
        text-align: center;
    }

    /* Add some styles for aesthetics */
    .box:nth-child(odd) {
        background-color: #f0f0f0;
    }

    .box:nth-child(even) {
        background-color: #e0e0e0;
    }
    /* Style for the table */
    table {
            width: 100%; /* Make the table width 100% of its container */
            border-collapse: collapse; /* Collapse borders for a clean look */
        }

        /* Style for table headers */
        th {
            background-color: #134f88; /* Header background color */
            color: #b7babd; /* Header text color */
            padding: 10px; /* Padding for header cells */
            text-align: left; /* Align header text to the left */
            padding: 10px; /* Adjust the padding as needed */
            border: 1px solid #ccc; /* Add borders for better visibility */
        }

        /* Add spacing between th elements */
        th + th {
            padding-left: 20px; /* Adjust spacing between th elements */
        }

        /* Style for table rows */
        tr {
            width: 100%; /* Set the row width to 100% */
        }

        /* Style for alternating row backgrounds */
        tr:nth-child(even) {
            background-color: #f2f2f2; /* Even row background color */
        }

        /* Style for table data cells */
        td {
            padding: 10px; /* Padding for data cells */
            border: 1px solid #ccc; /* Add border to data cells */
        }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="content-header">
            <div class="row ">
                <div class="col-md-4">

                     <!-- Apartment Selection Dropdown -->
                     @include('partials._apartment_dropdown')
                </div>

                <div class="col-md-4">
                    <!-- Middle section left empty -->
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                </div>

                <div class="col-md-4">
                    <h1>Total Users With Roles</h1>


                </div>



                {{-- <div id="assignCaretakerModal" style="display: none;">
                    <form action="{{ route('assignCaretaker', ['apartment' => $apartment]) }}" method="post">
                        @csrf
                        <label for="user_id">Select Caretaker:</label>
                        <select name="user_id" id="user_id">
                            @foreach($usersInApartmentWithCaretakerRole as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                        <button type="submit" class="btn btn-primary">Assign Caretaker Role</button>
                    </form>
                </div> --}}




                </div>
            </div>
    <section class="content">
        <div class="container">
        <div class="data-card-row">


                <div href="#" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Total Users With Roles</h5>
                        <p class="data-value"> {{ $totalUsers}}</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </div>

                <div href="#" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Tenants</h5>
                        <p class="data-value"> {{ $totalUsers}}</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </div>
                <div href="{{ route('landlord.manage.usersWithRoles', $apartment->id)}}" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Caratekers</h5>
                        <p class="data-value"> {{ $totalUsers}}</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </div>
                <div href="#" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Landlords</h5>
                        <p class="data-value"> $250,000</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </div>

        </div>
    </div>


                <table>
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Roles</th>
                            <th>Role Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($usersInApartment)
                        @foreach ($usersInApartment as $user)
                        <tr>
                            <td>{{ $user->name }}</td>
                            <td>
                                <ul>
                                    @foreach ($user->roles as $role)
                                        <li>{{ $role->name }}</li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>{{ $user->roleCount }}</td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
    </div>
@endsection

