 {{--  Display recent payments in a table --}}
 <div class="row">

    <form action="{{ route('handle_payments_action', $apartment->id) }}" method="post">
        @csrf
        <table class="table">
            <thead>
                <tr>
                    <th>Invoice Number</th>
                    <th>User Name</th>
                    <th>Payment Date</th>
                    <th>Amount Paid</th>
                    <th>Edit Payment Amount</th>
                    <th>Delete Payment</th>
                    <th>Transfer Payment</th>
                    <!-- Add more columns as needed -->
                </tr>
            </thead>
            <tbody>
                @foreach ($apartmentRecentPayments as $invoice)
                    @if(isset($invoice->payments) && is_iterable($invoice->payments))
                        @foreach ($invoice->payments as $index => $payment)
                            <tr>
                                @if($index === 0)
                                    <td rowspan="{{ count($invoice->payments) }}">{{ $invoice->invoice_number }}</td>
                                    <td rowspan="{{ count($invoice->payments) }}">{{ $invoice->user->name }}</td>
                                @endif
                                <td>{{ $payment['payment_date'] }}</td>
                                <td>{{ $payment['payment_amount'] }}</td>
                                <td>
                                    <input type="number" name="payment_{{ $index }}" value="{{ $payment['payment_amount'] }}">
                                </td>
                                <td>
                                    <input type="checkbox" name="delete_payment[]" value="{{ $index }}">
                                </td>
                                <td>
                                    <input type="checkbox" name="transfer_payment[]" value="{{ $index }}">
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td>{{ $invoice->invoice_number }}</td>
                            <td>{{ $invoice->user->name }}</td>
                            <td colspan="5">No payments available</td>
                        </tr>
                    @endif
                @endforeach
            </tbody>
        </table>
        <button type="submit" name="action" value="edit">Update Selected Payments</button>
        <button type="submit" name="action" value="remove">Delete Selected Payments</button>
        <button type="submit" name="action" value="transfer">Transfer Selected Payments</button>
    </form>
