@extends('layouts.tenant2-layout')

@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row">
                <div class="container">
                    <!-- Main content -->
                    <div class="invoice p-5 mb-6">
                        <!-- title row -->
                        <div class="row">

                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4>
                                            <!-- Display apartment image -->
@if($imagePath)
<img src="{{ asset($imagePath) }}" alt="Apartment Image">
@endif

                                        </h4>
                                    </div>
                                    <div class="col-md-6">
                                        <h4>
                                            <strong class="float-center {{ $invoice->payment_status }}">{{ $invoice->payment_status }}</strong>
                                        </h4>
                                    </div>
                                </div>


                                </h4>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- title row -->
                        <div class="row">

                            <div class="col-12">
                                <h4>
                                    <strong>#{{ $invoice->invoice_number }}</strong>
                                    <small class="float-right">{{ $invoice->created_at }}</small>
                                </h4>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- info row -->
                        <div class="row invoice-info">
                            <!-- /.col -->
                            <div class="col-md-4 col-sm-12 col-lg-4 invoice-col">
                                Invoiced To
                                <address>
                                    <strong>{{ Auth::user()->name }} {{ Auth::user()->last_name }}</strong><br>
                                    {{ Auth::user()->city }},{{ Auth::user()->address_1 }}<br>
                                    San Francisco, CA 94107<br>
                                    Phone: {{ Auth::user()->phone_number }}<br>
                                    {{ Auth::user()->email }}
                                </address>
                            </div>
                            <!-- /.col -->
                            <div class="col-md-4 col-sm-12 col-lg-4 invoice-col">
                                From
                                <address>
                                    <strong>{{ $apartment->name }}</strong><br>
                                    {{ $apartment->address }},{{ $apartment->city }}<br>
                                    {{ $apartment->location }},{{ $apartment->city }}<br>
                                    Phone: {{ $apartment->phone }}<br>
                                    Email: {{ $apartment->email }}
                                </address>
                            </div>

                            <div class="col-md-4 col-sm-12 col-lg-4 invoice-col">
                                <b>Payment Method: {{ Auth::user()->payment_method }}</b><br>
                                <br>
                                <b>Instructions<br>
                                    <b>Paybill:</b> 247247<br>
                                    <b>Account No:</b> 0280180439380<br>
                                    <button type="button" class="btn btn-success"><i
                                        class="far fa-credit-card"></i> Submit
                                    Payment
                                </button>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->

                        <!-- Table row -->
                        <div class="row">
                            <h5>Invoice Items</h5>

                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Description</th>
                                        <th> Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td> {{ $invoice->invoice_items }}

                                        </td>
                                        <td>
                                            {{ $apartment->currency}}.{{ $invoice->total_amount }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                        </div>
                        <!-- /.col -->

                        <!-- /.row -->

                        <div class="row">
                            <!-- accepted payments column -->
                            <div class="col-6">
                                <p class="lead">Payment Methods:</p>
                                <img src="../../dist/img/credit/mpesa.png" alt="Mpesa">
                                <img src="../../dist/img/credit/visa.png" alt="Visa">
                                <img src="../../dist/img/credit/mastercard.png" alt="Mastercard">
                                <img src="../../dist/img/credit/american-express.png" alt="American Express">
                                <img src="../../dist/img/credit/paypal2.png" alt="Paypal">
                                <img src="../../dist/img/credit/cash.png" alt="Cash">

                                <p class="text-muted well well-sm shadow-none" style="margin-top: 10px;">
                                    This apartment suports the above payment methods
                                </p>
                            </div>
                            <!-- /.col -->
                            <div class="col-6">
                                {{-- <p class="lead">Amount Due 2/22/2014</p> --}}

                                <div class="table-responsive">
                                    <table class="table">
                                        <tr>
                                            <th style="width:50%">Subtotal:</th>
                                            <td><strong>{{ $apartment->currency}}.{{ $invoice->total_amount }}</strong></td>
                                        </tr>
                                        <tr>
                                            <th>Tax (0%)</th>
                                            <td>{{ $apartment->currency}}.0</td>
                                        </tr>

                                        <tr>
                                            <th>Total:</th>
                                            <td><strong>{{ $apartment->currency}}.{{ $invoice->total_amount }}</strong></td>
                                        </tr>
                                    </table>
                                </div>

                            </div>
                        </div>
                        <!-- /.col -->

                        <!-- /.row -->
                        {{-- <div class="row">
                            <div class="col-md-12">
                                <h5>Transactions</h5>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Description</th>
                                                <th> Amount</th>
                                            </tr>
                                        </thead>
                                        <tr>
                                            <th>Tax (0%)</th>
                                            <td>$0</td>
                                        </tr>
                                        <tr>
                                            <th>Shipping:</th>
                                            <td>$5.80</td>
                                        </tr>
                                        <tr>
                                            <th>Invoice Balance:</th>
                                            <td>{{ $invoice->balance }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div> --}}
                        <div class="row">
                            <div class="col">
                                <h4>Transactions</h4>

                                @if (!empty($invoice->payments) && is_array(json_decode($invoice->payments, true)))
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Payment Method</th>
                                                <th>Transaction ID</th>
                                                <th>Amount</th>
                                                <th>Transaction Fee</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (json_decode($invoice->payments, true) as $transaction)
                                            <tr>
                                                <td>{{ $transaction['payment_date'] }}</td>
                                                <td>{{ $transaction['payment_method'] }}</td>
                                                <td>{{ $transaction['transaction_id'] }}</td>
                                                <td>{{ $transaction['payment_amount'] }}</td>
                                                <td>{{ $transaction['transaction_fee'] }}</td>


                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                @else
                                    <p>No transactions available.</p>
                                @endif
                            </div>
                        </div>
                        <!-- this row will not appear when printing -->
                        <div class="row no-print">
                            <div class="col-12">
                                <a href="invoice-print.html" rel="noopener" target="_blank" class="btn btn-default"><i
                                        class="fas fa-print"></i> Print</a>

                                <button type="button" class="btn btn-primary float-right" style="margin-right: 5px;">
                                    <i class="fas fa-download"></i> Generate PDF
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- /.invoice -->
                </div>
            </div>
            {{-- <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            @if ($invoice->rooms)
            @if ($invoice->rooms->apartment)
                <h1># {{ $invoice->rooms->apartment->apartment_name }}</h1>
            @else
                <p>No apartment associated with the room.</p>
            @endif
        @else
            <p>No rooms associated with the invoice.</p>
        @endif




                        <h1># {{ $invoice->invoice_number }}</h1>

                        </div>
                        <div class="col-sm-6">
                            <h1>{{ $invoice->payment_status }}</h1>
                        </div>
                    </div>
                    <hr style="border-top: 2px solid #ccc; margin: 20px 0;">



    <div class="row mb-2">

        <div class="row">
                <!--Invoice items-->
                <div class="container-fluid">
                    <div class="inner-box">
                    <div class="row">
                        <div class="col">
                            <h2>Invoice Items</h2>

                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Description</th>
                                            <th> Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td> {{ $invoice->invoice_items}}

                                            </td>
                                            <td>
                                                {{ $invoice->total_amount }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>


                        </div>
                    </div>
                    </div>
                </div>

        </div>
    </div>
      </div> --}}
        </div>
    </div>
@endsection
