@extends('layouts.tenant2-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">


                        <h1>Welcome, {{ auth()->user()->name }}</h1>

                        </div>
                    </div>



    <div class="row">
        <div class="data-card-row">


                <div class="data-card bg-success">
                    <div class="left-section">
                        <h5 class="data-title">Total Sales</h5>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i> $250,000</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                    <div class="right-section">
                        <h6 class="section-title">Top Products</h6>
                        <ul class="product-list">
                            <li>Product A</li>
                            <li>Product B</li>
                            <li>Product C</li>
                            <!-- Add more product listings as needed -->
                        </ul>
                    </div>
                </div>
                @foreach ($rooms as $room)
                <div class="data-card bg-success">
                    <div class="top-section">
                        <h3 class="data-title">Room No:</h3>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i> {{ $room->room_number }}</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                    <div class="bottom-section">
                        <h4 class="section-title">Top Products</h4>
                        <ul class="product-list">
                            <li>Apartment</li>
                            <li>Product B</li>
                            <li>Product C</li>
                            <!-- Add more product listings as needed -->
                        </ul>
                    </div>
                </div>
                @endforeach
                <a href="{{ route('list-invoices')}}" class="data-card-link"target="_blank" bg-success>
                    <div class="data-card">
                        <h5 class="data-title">Total Paid This Month</h5>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i> <p><strong>Room Number:</strong> {{ $room->room_number }}</p>

                        {{-- Check if the apartments relationship exists before accessing its properties --}}
                        @if ($room->apartments && $room->apartments->isNotEmpty())
                            @foreach ($room->apartments as $apartment)
                                <p><strong>Apartment Name:</strong> {{ $apartment->pivot->apartment_name }}</p>
                                {{-- Add more details as needed --}}
                            @endforeach
                        @else
                            <p><em>No associated apartments</em></p>
                        @endif</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </a>

                <a href="#" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Unpaid Invoices</h5>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->

                        </div>
                    </div>
                </a>

        </div>
    </div>

</div>


@endsection

