<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoomController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ApartmentController;
use App\Http\Controllers\WatchlistController;
use App\Http\Controllers\MpesaSTKPUSHController;
use App\Http\Controllers\Api\v1\TenantController;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/test', function () {
    return response()->json(['message' => 'Test route']);
});

Route::get('/api-test', function () {
    dd('api-test');
    return response()->json(['message' => 'API test route']);
});

Route::group(['prefix' => 'v1'], function () {
    Route::get('/users', [UserController::class, 'index']); // Using Controller method directly

    // Public route to view rooms
    Route::get('/rooms', [RoomController::class, 'getEmptyRoom']);
    Route::get('/apartments', [ApartmentController::class, 'getApartmentsWithRooms']); // Using Controller method directly
    Route::get('/rooms/{location}', [RoomController::class, 'getEmptyRoomWithLocation']);
    Route::get('/empty-rooms', [RoomController::class, 'getEmptyRooms']);

   // Route::post('/watchlist/add', [WatchlistController::class, 'addToWatchlist']);

    // Mpesa STK Push Callback Route
    Route::post('/confirm', [MpesaSTKPUSHController::class, 'STKConfirm'])->name('mpesa.confirm');
    Route::middleware('auth:sanctum')->post('/watchlist/add', [WatchlistController::class, 'addToWatchlist']);

    Route::middleware('auth:sanctum')->post('/rooms/book', [RoomController::class, 'bookRoom']);
    Route::middleware('auth:sanctum')->post('/services/book', [RoomController::class, 'bookService']);


});

// Protected route to book rooms
Route::middleware('auth:api')->post('/rooms/book', [RoomController::class, 'book']); // Using Controller method directly
