<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PdfController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\RoomController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Redirect;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\TableController;
use App\Http\Controllers\CountyController;
use App\Http\Controllers\TenantController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\PaymentsController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\SessionsController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\UserTaskController;
use App\Http\Controllers\AdminRoomController;
use App\Http\Controllers\ApartmentController;
use App\Http\Controllers\SocialAuthController;
use App\Http\Controllers\OnlineAdminController;
use App\Http\Controllers\ApartmentSMSController;
use App\Http\Controllers\MpesaPaymentController;
use App\Http\Controllers\MpesaSTKPUSHController;
use App\Http\Controllers\ApartmentUserController;
use App\Http\Controllers\EmailTemplateController;
use App\Http\Controllers\TenantServiceController;
use App\Http\Controllers\ApartmentEmailController;
use App\Http\Controllers\MarketingPlaceController;
use App\Http\Controllers\RoleAssignmentController;
use App\Http\Controllers\RoomAssignmentController;
use App\Http\Controllers\TenantSettingsController;
use App\Http\Controllers\ApartmentChartsController;
use App\Http\Controllers\LandlordInvoiceController;
use App\Http\Controllers\LandlordLicenseController;
use App\Http\Controllers\LandlordReportsController;
use App\Http\Controllers\SettingsChangesController;
use App\Http\Controllers\ApartmentExpensesController;
use App\Http\Controllers\ApartmentSettingsController;
use App\Http\Controllers\ApartmentAssignmentController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// //Dashboard
// Route::group(['middleware' => ['get.menu']], function () {
//     Route::get('/', function () {           return view('dashboard.homepage'); });

//     Route::group(['middleware' => ['role:user']], function () {
//         Route::get('/colors', function () {     return view('dashboard.colors'); });
//         Route::get('/typography', function () { return view('dashboard.typography'); });
//         Route::get('/charts', function () {     return view('dashboard.charts'); });
//         Route::get('/widgets', function () {    return view('dashboard.widgets'); });
//         Route::get('/404', function () {        return view('dashboard.404'); });
//         Route::get('/500', function () {        return view('dashboard.500'); });
//         Route::prefix('base')->group(function () {
//             Route::get('/breadcrumb', function(){   return view('dashboard.base.breadcrumb'); });
//             Route::get('/cards', function(){        return view('dashboard.base.cards'); });
//             Route::get('/carousel', function(){     return view('dashboard.base.carousel'); });
//             Route::get('/collapse', function(){     return view('dashboard.base.collapse'); });

//             Route::get('/forms', function(){        return view('dashboard.base.forms'); });
//             Route::get('/jumbotron', function(){    return view('dashboard.base.jumbotron'); });
//             Route::get('/list-group', function(){   return view('dashboard.base.list-group'); });
//             Route::get('/navs', function(){         return view('dashboard.base.navs'); });

//             Route::get('/pagination', function(){   return view('dashboard.base.pagination'); });
//             Route::get('/popovers', function(){     return view('dashboard.base.popovers'); });
//             Route::get('/progress', function(){     return view('dashboard.base.progress'); });
//             Route::get('/scrollspy', function(){    return view('dashboard.base.scrollspy'); });

//             Route::get('/switches', function(){     return view('dashboard.base.switches'); });
//             Route::get('/tables', function () {     return view('dashboard.base.tables'); });
//             Route::get('/tabs', function () {       return view('dashboard.base.tabs'); });
//             Route::get('/tooltips', function () {   return view('dashboard.base.tooltips'); });
//         });
//         Route::prefix('buttons')->group(function () {
//             Route::get('/buttons', function(){          return view('dashboard.buttons.buttons'); });
//             Route::get('/button-group', function(){     return view('dashboard.buttons.button-group'); });
//             Route::get('/dropdowns', function(){        return view('dashboard.buttons.dropdowns'); });
//             Route::get('/brand-buttons', function(){    return view('dashboard.buttons.brand-buttons'); });
//         });
//         Route::prefix('icon')->group(function () {  // word: "icons" - not working as part of adress
//             Route::get('/coreui-icons', function(){         return view('dashboard.icons.coreui-icons'); });
//             Route::get('/flags', function(){                return view('dashboard.icons.flags'); });
//             Route::get('/brands', function(){               return view('dashboard.icons.brands'); });
//         });
//         Route::prefix('notifications')->group(function () {
//             Route::get('/alerts', function(){   return view('dashboard.notifications.alerts'); });
//             Route::get('/badge', function(){    return view('dashboard.notifications.badge'); });
//             Route::get('/modals', function(){   return view('dashboard.notifications.modals'); });
//         });
//         Route::resource('notes', 'NotesController');
//     });
//     Auth::routes();

//     Route::resource('resource/{table}/resource', 'ResourceController')->names([
//         'index'     => 'resource.index',
//         'create'    => 'resource.create',
//         'store'     => 'resource.store',
//         'show'      => 'resource.show',
//         'edit'      => 'resource.edit',
//         'update'    => 'resource.update',
//         'destroy'   => 'resource.destroy'
//     ]);

//     Route::group(['middleware' => ['role:admin']], function () {
//         Route::resource('bread',  'BreadController');   //create BREAD (resource)
//         Route::resource('users',        'UsersController')->except( ['create', 'store'] );
//         Route::resource('roles',        'RolesController');
//         Route::resource('mail',        'MailController');
//         Route::get('prepareSend/{id}',        'MailController@prepareSend')->name('prepareSend');
//         Route::post('mailSend/{id}',        'MailController@send')->name('mailSend');
//         Route::get('/roles/move/move-up',      'RolesController@moveUp')->name('roles.up');
//         Route::get('/roles/move/move-down',    'RolesController@moveDown')->name('roles.down');
//         Route::prefix('menu/element')->group(function () {
//             Route::get('/',             'MenuElementController@index')->name('menu.index');
//             Route::get('/move-up',      'MenuElementController@moveUp')->name('menu.up');
//             Route::get('/move-down',    'MenuElementController@moveDown')->name('menu.down');
//             Route::get('/create',       'MenuElementController@create')->name('menu.create');
//             Route::post('/store',       'MenuElementController@store')->name('menu.store');
//             Route::get('/get-parents',  'MenuElementController@getParents');
//             Route::get('/edit',         'MenuElementController@edit')->name('menu.edit');
//             Route::post('/update',      'MenuElementController@update')->name('menu.update');
//             Route::get('/show',         'MenuElementController@show')->name('menu.show');
//             Route::get('/delete',       'MenuElementController@delete')->name('menu.delete');
//         });
//         Route::prefix('menu/menu')->group(function () {
//             Route::get('/',         'MenuController@index')->name('menu.menu.index');
//             Route::get('/create',   'MenuController@create')->name('menu.menu.create');
//             Route::post('/store',   'MenuController@store')->name('menu.menu.store');
//             Route::get('/edit',     'MenuController@edit')->name('menu.menu.edit');
//             Route::post('/update',  'MenuController@update')->name('menu.menu.update');
//             Route::get('/delete',   'MenuController@delete')->name('menu.menu.delete');
//         });
//         Route::prefix('media')->group(function () {
//             Route::get('/',                 'MediaController@index')->name('media.folder.index');
//             Route::get('/folder/store',     'MediaController@folderAdd')->name('media.folder.add');
//             Route::post('/folder/update',   'MediaController@folderUpdate')->name('media.folder.update');
//             Route::get('/folder',           'MediaController@folder')->name('media.folder');
//             Route::post('/folder/move',     'MediaController@folderMove')->name('media.folder.move');
//             Route::post('/folder/delete',   'MediaController@folderDelete')->name('media.folder.delete');;

//             Route::post('/file/store',      'MediaController@fileAdd')->name('media.file.add');
//             Route::get('/file',             'MediaController@file');
//             Route::post('/file/delete',     'MediaController@fileDelete')->name('media.file.delete');
//             Route::post('/file/update',     'MediaController@fileUpdate')->name('media.file.update');
//             Route::post('/file/move',       'MediaController@fileMove')->name('media.file.move');
//             Route::post('/file/cropp',      'MediaController@cropp');
//             Route::get('/file/copy',        'MediaController@fileCopy')->name('media.file.copy');
//         });
//     });
// });

// //end dashboard

// Route::get('/', function () {
//     return view('welcome');
//});
//routes for pages

Route::get('/signup', function () {

    if (Auth::check()) {
        return redirect('userdashboard');
    } else {
        return view('signup');
    }


});

// Authentication Routes...
//Route::get('/login', 'Auth\LoginController@showLoginForm')->name('login');
//Route::post('/login', 'Auth\LoginController@login');
//Route::post('/logout', 'Auth\LoginController@logout')->name('logout');

// Registration Routes...
Route::get('/register', [App\Http\Controllers\RegistrationController::class, 'create'])->name('register');
Route::post('/register', [App\Http\Controllers\RegistrationController::class, 'store']);

// Password Reset Routes...
Route::get('/password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('/password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
Route::get('/password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('/password/reset', 'Auth\ResetPasswordController@reset');



Route::get('login/{provider}', [SocialAuthController::class, 'redirectToProvider'])->name('social.login');
Route::get('login/{provider}/callback', [SocialAuthController::class, 'handleProviderCallback']);


Route::view('login', 'login');
//routes for register
//Route::get('/register', [App\Http\Controllers\RegisterController::class, 'create'])->name('register');
//Route::get('/register', [App\Http\Controllers\RegisterController::class, 'store']);

//routes for auth
//Route::get('/signup', [App\Http\Controllers\RegistrationController::class, 'create']);
//Route::post('/signup', [App\Http\Controllers\RegistrationController::class, 'store']);


Route::get('/admin/login', [App\Http\Controllers\AdminController::class, 'login'])->middleware('adminAuth');
Route::get('/login', [App\Http\Controllers\SessionsController::class, 'create']);
Route::post('/login', [App\Http\Controllers\SessionsController::class, 'store']);
Route::get('/logout', [App\Http\Controllers\SessionsController::class, 'destroy'])->name('logout');

// Profile Routes
Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'showProfile'])->name('profile.show');
Route::get('profile/edit', [App\Http\Controllers\ProfileController::class, 'edit'])->name('profile.edit');
Route::put('profile', [App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');

//Tasks
Route::middleware(['auth'])->group(function () {
    Route::get('/tasks', [UserTaskController::class, 'index'])->name('tasks.index');
    Route::post('/tasks', [UserTaskController::class, 'store'])->name('tasks.store');
    Route::delete('/tasks/{task}', [UserTaskController::class, 'destroy'])->name('tasks.destroy');
    Route::patch('/tasks/{task}/cancel', [UserTaskController::class, 'cancel'])->name('tasks.cancel');
    Route::patch('/tasks/{task}/complete', [UserTaskController::class, 'complete'])->name('tasks.complete');
});

//tickets
Route::get('/user/ticket', [TicketController::class, 'index'])->name('tickets.index');
Route::get('/user/ticket', [App\Http\Controllers\TicketController::class, 'create'])->name('tickets.create');
Route::post('/tickets/store', [App\Http\Controllers\TicketController::class, 'store'])->name('tickets.store');


Auth::routes();
Route::middleware(['auth', 'redirectBasedOnRole'])->group(function () {
    // Route::get('/user', [App\Http\Controllers\HomeController::class, 'index'])->name('user.home');
    //Route::get('/user', [App\Http\Controllers\UserController::class, 'index'])->name('user.home');
    Route::get('/', function () {
        return redirect('/home');
    });
    Route::get('', function () {
        return redirect('/home');
    });
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->middleware('redirectBasedOnRole')->name('home');
});

Route::prefix('admin')->middleware(['auth', 'is_admin', 'check.session.expired',])->group(function () {
    //Dashboard


    // Route::get('/home', function (){return Redirect::to('/admin');})->name('admin.home');
    // Route::get('', function (){return Redirect::to('/admin');})->name('admin-home');
    Route::get('/', [OnlineAdminController::class, 'onlineadmins'])->name('admin-home');
    Route::get('/', [AdminController::class, 'index'])->name('admin-home');
    Route::get('/', [App\Http\Controllers\PaymentsController::class, 'payments'])->name('admin.home');
    Route::get('/', [App\Http\Controllers\AdminController::class, 'adminDashboard'])->name('admin.home');


    //Apartments
    Route::get('/apartments', [App\Http\Controllers\ApartmentAssignmentController::class, 'showAllApartments'])->name('allApartments')->middleware(['is_admin']);
    Route::get('/apartmentsByCounty', [App\Http\Controllers\ApartmentAssignmentController::class, 'showAllApartmentsWithCounty'])->name('allApartmentsWithCounty')->middleware(['is_admin']);

    Route::post('/apartments', [ApartmentAssignmentController::class, 'store'])->name('assignrole')->middleware(['is_admin']);


    //Rooms
    Route::get('//pages/roomsoccupied', [App\Http\Controllers\AdminRoomController::class, 'rooms'])->name('roomsoccupied')->middleware(['is_admin']);
    Route::get('//pages/roomsoccupied', [App\Http\Controllers\AdminController::class, 'users'])->name('roomsoccupied')->middleware(['is_admin']);
    Route::get('/pages/roomsoccupied', [App\Http\Controllers\RoomAssignmentController::class, 'usersWithRoom'])->name('roomsoccupied');
    Route::get('/pages/roomsoccupied', [App\Http\Controllers\UserController::class, 'getRoomsCount'])->name('roomsoccupied');
    //Route::get('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'showInvoice'])->name('show-invoice')->middleware(['is_admin']);


    Route::get('/rooms', [App\Http\Controllers\ApartmentAssignmentController::class, 'showAssignRoomToApartmentForm'])->name('rooms.index');
    Route::post('/rooms', [App\Http\Controllers\ApartmentAssignmentController::class, 'apartmentassign'])->name('roomsApartments');
    Route::get('/rooms/assign-apartment/{roomId}', [App\Http\Controllers\RoomController::class, 'assignApartment'])->name('rooms.assignApartment');
    Route::get('/rooms/assign-tenant/{roomId}', [App\Http\Controllers\RoomController::class, 'assignTenant'])->name('rooms.assignTenant');
    Route::get('/rooms/remove-tenant/{roomId}', [App\Http\Controllers\RoomController::class, 'removeTenant'])->name('rooms.removeTenant');
    // Route::get('/admin/admin-home', [App\Http\Controllers\HomeController::class, 'adminHome'])->name('admin.home')->middleware(['is_admin']);
    //Route::get('/admin/pages/roomsoccupied', [App\Http\Controllers\HomeController::class, 'roomsoccupied'])->name('roomsoccupied')->middleware(['is_admin']);


    //invoices

    Route::get('/invoices', [App\Http\Controllers\PaymentsController::class, 'index'])->name('admin.invoices')->middleware(['is_admin']);
    // Route::get('/admin/invoices/paid', [App\Http\Controllers\PaymentsController::class, 'showPaidInvoices'])->name('admin.invoices')->middleware(['is_admin']);
    // Route::get('/admin/invoices/unpaid', [App\Http\Controllers\PaymentsController::class, 'showUnpaidInvoices'])->name('admin.invoices')->middleware(['is_admin']);

    Route::get('/thisMonthInvoices', [App\Http\Controllers\PaymentsController::class, 'thismonth'])->name('admin.this-month-invoices')->middleware(['is_admin']);
    Route::get('/invoices/{invoice}/edit', [App\Http\Controllers\PaymentsController::class, 'editInvoice'])->name('edit-invoice')->middleware(['is_admin']);
    Route::post('/invoices/delete-invoices', [App\Http\Controllers\PaymentsController::class, 'deleteInvoices'])->name('delete-invoices')->middleware(['is_admin']);


    Route::get('/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'showInvoice'])->name('admin.invoice.show')->middleware(['is_admin']);
    Route::get('/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'showInvoice'])->name('show-invoice')->middleware(['is_admin']);
    Route::get('/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'updateInvoiceItems'])->name('update-invoice')->middleware(['is_admin']);
    Route::post('/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'updateInvoiceItems'])->name('update-invoice')->middleware(['is_admin']);
    Route::put('/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'updateInvoiceItems'])->name('update-invoice')->middleware(['is_admin']);
    Route::post('/invoices/{invoice}/add-payment', [App\Http\Controllers\PaymentsController::class, 'addPayment'])->name('invoice.addPayment')->middleware(['is_admin']);
    Route::post('/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'markStatus'])->name('invoice.markStatus')->middleware(['is_admin']);
    Route::post('/invoices/{invoice}/update', [App\Http\Controllers\PaymentsController::class, 'update'])->name('invoices.update')->middleware(['is_admin']);
    Route::patch('/invoices/{invoice}/update', [App\Http\Controllers\PaymentsController::class, 'update'])->name('invoices.update')->middleware(['is_admin']);
    Route::post('/invoices/delete-invoices', [App\Http\Controllers\PaymentsController::class, 'deleteInvoices'])->name('delete-invoices')->middleware(['is_admin']);

    Route::get('/invoices/this-month', [App\Http\Controllers\PaymentsController::class, 'thisMonth']);
    // Route::get('/invoices/this-month/status/{status}', [App\Http\Controllers\PaymentsController::class, 'thisMonthFilteredByStatus'])->name('admin.invoices-thisMonthFilteredByStatus')->middleware(['is_admin']);


    // routes/web.php or routes/api.php

    Route::post('/send-email', 'ApartmentEmailController@sendEmail')->name('send-email');
    Route::post('/send-sms', 'ApartmentSMSController@sendSMS')->name('send-sms');

    //Reports
    Route::get('/monthlyreport', [App\Http\Controllers\ReportsController::class, 'monthlyReport'])->name('monthly-report')->middleware(['is_admin']);
    Route::get('/thismonthreport', [ReportsController::class, 'ThisMonthReport'])->name('this-month-report')->middleware(['is_admin']);


    //Support Tickets
    Route::get('/supporttickets', [SupportController::class, 'index'])->name('show.tickets')->middleware(['is_admin']);
    Route::get('/tickets', [App\Http\Controllers\SupportController::class, 'index'])->name('tickets.index')->middleware(['is_admin']);
    Route::get('/tickets/{ticket}', [App\Http\Controllers\SupportController::class, 'show'])->name('tickets.show')->middleware(['is_admin']);
    Route::post('/tickets/{ticket}/reply', [App\Http\Controllers\SupportController::class, 'reply'])->name('tickets.reply')->middleware(['is_admin']);
    Route::post('/tickets/update-status/{ticketId}', [App\Http\Controllers\SupportController::class, 'updateStatus'])->middleware(['is_admin']);

    // Route::get('/invoices/create', 'InvoiceController@create')->name('invoices.create');
    // Route::post('/invoices/store', 'InvoiceController@store')->name('invoices.store');
    // Route::get('/invoices/{invoice}/edit', 'InvoiceController@edit')->name('invoices.edit');
    // Route::put('/invoices/{invoice}', 'InvoiceController@update')->name('invoices.update');


    //ADmin routes
    //Route::get('/home', function (){return Redirect::to('/admin');})->name('admin.home')->middleware(['is_admin']);
    // Route::get('', function (){return Redirect::to('/admin');})->name('admin.home')->middleware(['is_admin']);
    // Route::get('/admin', [App\Http\Controllers\AdminController::class, 'index'])->name('admin.home')->middleware(['is_admin']);
    // Route::get('/admin', [PaymentsController::class, 'payments'])->name('admin.home')->middleware(['is_admin']);
    // Route::get('/admin', [App\Http\Controllers\SupportControllerController::class, 'adminDashboard'])->name('admin.home')->middleware(['is_admin']);

    // /Users', [App\Http\Controllers\AdminController::class, 'users'])->name('adminusers')->middleware(['is_admin']);
    Route::get('/Users', [RoomAssignmentController::class, 'index'])->name('adminusers')->middleware(['is_admin']);
    Route::get('/Users', [App\Http\Controllers\RoomAssignmentController::class, 'showAssignForm'])->name('adminusers')->middleware(['is_admin']);
    Route::get('/Users/get-apartments', [App\Http\Controllers\RoomAssignmentController::class, 'getAllApartments'])->name('adminusers')->middleware(['is_admin']);
    Route::get('Users/get-rooms/{apartmentId}', [App\Http\Controllers\RoomAssignmentController::class, 'getRoomsByApartment'])->name('adminusers')->middleware(['is_admin']);
    Route::post('/Users', [App\Http\Controllers\RoomAssignmentController::class, 'assignURoom'])->name('assign.room');
    Route::post('/Users', [App\Http\Controllers\RoomAssignmentController::class, 'assign'])->name('assign.room');
    Route::post('/Users', [App\Http\Controllers\StatisticsController::class, 'showStatistics'])->name('rooms.assign');
    Route::get('/Users', [UserController::class, 'getUsersCount'])->name('assign.room');
    Route::get('/assign-apartment', [ApartmentAssignmentController::class, 'index'])->name('assign.apartment');
    Route::post('/assign-apartment', [ApartmentAssignmentController::class, 'storeUser'])->name('assign.apartment.store');

    Route::get('/search-user', [UserController::class, 'searchUser']);


    //landlords
    Route::get('/admin/landlords', [UserController::class, 'showLandlords'])->name('landlords')->middleware(['is_admin']);
    Route::get('/apartments', [App\Http\Controllers\ApartmentAssignmentController::class, 'showAssignmentForm'])->name('allApartments')->middleware(['is_admin']);
    Route::post('/assign-landlord', [App\Http\Controllers\ApartmentAssignmentController::class, 'assignLandlord'])->name('assign.landlord')->middleware(['is_admin']);
    // Route::post('/assign-role', [App\Http\Controllers\RoleAssignmentController::class, 'assignRole'])->name('assign.role');
    // Route::get('/assign-role', [App\Http\Controllers\RoleAssignmentController::class, 'showRoleAssignmentForm'])->name('assign.role.form')->middleware(['is_admin']);

    Route::get('/admin/landlords', [RoleAssignmentController::class, 'assignLandlordRole']);
    Route::get('/assign-tenant-role', 'RoleAssignmentController@assignTenantRole');
    Route::get('/assign-caretaker-role', 'RoleAssignmentController@assignCaretakerRole');
    Route::post('/assign-landlord-role', [App\Http\Controllers\RoleAssignmentController::class, 'assignLandlordRoleToUser'])->name('assign.landlord.role');
    Route::post('/assign-tenant-role', 'RoleAssignmentController@assignTenantRoleToUser')->name('assign.tenant.role');
    Route::post('/assign-caretaker-role', 'RoleAssignmentController@assignCaretakerRoleToUser')->name('assign.caretaker.role');


    //caretakers
    Route::get('/admin/caretakers', [UserController::class, 'showCaretakers'])->name('landlords')->middleware(['is_admin']);
    //Rooms assingmen
    // Route::get('admin/assign', 'RoomAssignmentController@index');
    // Route::post('admin/assign', 'RoomAssignmentController@store');
    // Route::get('admin/assignments', 'RoomAssignmentController@list');

    Route::get('/services', [ServiceController::class, 'index'])->name('admin.services.index');
    // Route::get('/services/{service}', [ServiceController::class, 'show'])->name('admin.services.show');
    Route::get('/services/creeate', [ServiceController::class, 'create'])->name('admin.services.create');
    Route::post('/services', [ServiceController::class, 'store'])->name('admin.services.store');
    Route::get('/services/{service}/edit', [ServiceController::class, 'edit'])->name('services.edit');
    Route::put('/services/{service}', [ServiceController::class, 'update'])->name('services.update');
    Route::delete('/services/{service}', [ServiceController::class, 'destroy'])->name('services.destroy');

    // Email Templates
    Route::get('/email-templates', [EmailTemplateController::class, 'index'])->name('admin.email-templates.index');
    Route::get('/email-templates/create', [EmailTemplateController::class, 'create'])->name('email-templates.create');
    Route::post('/email-templates', [EmailTemplateController::class, 'store'])->name('email-templates.store');
    Route::get('/email-templates/{emailTemplate}/edit', [EmailTemplateController::class, 'edit'])->name('email-templates.edit');
    Route::put('/email-templates/{emailTemplate}', [EmailTemplateController::class, 'update'])->name('email-templates.update');
    Route::delete('/email-templates/{emailTemplate}', [EmailTemplateController::class, 'destroy'])->name('email-templates.destroy');
    // Route::get('/apartments/{apartment}/attach-template', 'ApartmentController@showAttachTemplateForm')->name('apartments.attach-template');
    // Route::post('/apartments/{apartment}/attach-template', 'ApartmentController@attachTemplate')->name('apartments.attach-template');

    Route::get('/apartments/attach-template', [EmailTemplateController::class, 'showAttachTemplateForm'])->name('showapartments.attach-template');
    Route::post('/apartments/attach-template', [EmailTemplateController::class, 'attachTemplate'])->name('apartments.attach-template');

    // web.php
// Route::post('/send-email/{apartmentId}', [EmailController::class, 'sendEmail'])->name('send.email');
Route::post('/invoice-email', [EmailController::class, 'sendEmail'])->name('landlord-send.email');
Route::post('/send-sms', [EmailController::class, 'sendSMS'])->name('send.sms');
Route::get('/send-welcome-email', [EmailController::class, 'sendWelcomeEmail']);



});
Route::get('/counties', [CountyController::class, 'index'])->name('admin.counties.index');
Route::get('/counties/create', [CountyController::class, 'create'])->name('admin.counties.create');
Route::post('/counties/store', [CountyController::class, 'store'])->name('admin.counties.store');
Route::get('/counties/{county}/edit', [CountyController::class, 'edit'])->name('admin.counties.edit');
Route::put('/counties/{county}', [CountyController::class, 'update'])->name('admin.counties.update');
Route::delete('/counties/{county}', [CountyController::class, 'destroy'])->name('admin.counties.destroy');

//Auth::routes();
//Route::get('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'showInvoice'])->name('show-invoice');
//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

//assign room
//Route::get('/rooms/{roomId}/assign/{userId}', [App\Http\Controllers\RoomAssignmentController::class, 'index'])->name('rooms.assign');
//Route::post('/rooms/{roomId}/assign/{userId}', [App\Http\Controllers\RoomAssignmentController::class, 'assign'])->name('rooms.assign');
//Route::get('/admin/users/{userId}/assign', [App\Http\Controllers\RoomAssignmentController::class, 'showAssignmentForm'])->name('admin.users.assign');

//assign room
//Route::get('/rooms/{roomId}/assign/{userId}', [App\Http\Controllers\RoomAssignmentController::class, 'index'])->name('rooms.assign');
//Route::post('/rooms/{roomId}/assign/{userId}', [App\Http\Controllers\RoomAssignmentController::class, 'assign'])->name('rooms.assign');
//Route::get('/admin/users/{userId}/assign', [App\Http\Controllers\RoomAssignmentController::class, 'showAssignmentForm'])->name('admin.users.assign');

// Route::get('/admin/invoices', [App\Http\Controllers\PaymentsController::class, 'index'])->name('admin.invoices')->middleware(['is_admin']);
// Route::get('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'showInvoice'])->name('admin.invoice.show');
// Route::get('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'showInvoice'])->name('show-invoice')->middleware(['is_admin']);
// Route::get('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'updateInvoiceItems'])->name('update-invoice')->middleware(['is_admin']);
// Route::post('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'updateInvoiceItems'])->name('update-invoice')->middleware(['is_admin']);
// Route::put('/admin/invoices/{invoice}', [App\Http\Controllers\PaymentsController::class, 'updateInvoiceItems'])->name('update-invoice')->middleware(['is_admin']);

// Routes accessible only to landlords

Route::middleware(['auth', 'is_landlord', 'apartment-access', 'check.session.expired'])->group(function () {


    // Define landlord-specific routes here
    //Dashboard

    Route::get('/landlord', [App\Http\Controllers\LandlordController::class, 'index'])->name('landlord-home');
    //Route::get('/landlord/manage/{apartment}', [App\Http\Controllers\LandlordController::class, 'manage'])->name('landlord.manage');


    Route::post('/apartments/{apartment}/assign-caretaker/{user}', [App\Http\Controllers\CaretakerController::class, 'assignCaretaker'])->name('assignCaretaker');
    Route::get('/landlord/manage/{apartment}', [App\Http\Controllers\ApartmentController::class, 'show'])->name('landlord.apartment-dashboard');
    Route::get('/landlord/manage/{apartment}/rooms', [App\Http\Controllers\RoomController::class, 'showApartmentRooms'])->name('landlord.manage.rooms');

    //users
    Route::get('/landlord/manage/{apartment}/users', [App\Http\Controllers\UserController::class, 'usersInApartment'])->name('landlord.manage.users');
    Route::get('/landlord/manage/{apartment}/ResponsibleUsers', [App\Http\Controllers\UserController::class, 'usersWithRolesInApartment'])->name('landlord.manage.usersWithRoles');
    Route::get('/landlord/manage/{apartment}/landlords', [App\Http\Controllers\UserController::class, 'apartmentLandlords'])->name('apartment-landlords');
    Route::get('/landlord/manage/{apartment}/caretakers', [App\Http\Controllers\UserController::class, 'apartmentCaretakers'])->name('apartment-caretakers');
    Route::get('/landlord/manage/{apartment}/AddUser', [ApartmentUserController::class, 'index'])->name('landlord-add-user');
    Route::get('/update-table-data/{apartmentId}', [TableController::class, 'updateApartmentUserTableData']);
    Route::get('/landlord/{apartment}/Tenant/{usersInApartment}/users', [App\Http\Controllers\UserController::class, 'userProfileInApartment'])->name('landlord-view-tenant-profile');
    Route::get('/landlord/{apartment}/Tenant/{tenant}/id=/{order}', [App\Http\Controllers\UserController::class, 'usersInApartmentorder'])->name('landlord-tenant-product');

    //modify user data
    //Route::match(['get', 'post'], '/landlord/save-profile/{apartment}/Tenant/{tenant}/users', [App\Http\Controllers\UserController::class, 'userUpdateProfileInApartment']);
    Route::post('/landlord/save-profile/{apartment}/Tenant/{tenant}/users', [App\Http\Controllers\UserController::class, 'userUpdateProfileInApartments']);
    Route::post('/landlord/save-profile/{apartment}/tenant/{tenant}/update', [App\Http\Controllers\UserController::class, 'userUpdateProfileInApartment'])->name('update-tenant-profile');
    Route::get('/landlord/{apartment}/register-Tenant', [App\Http\Controllers\LandlordController::class, 'registerNewTenant'])->name('landlord.add-new-tenant');
    Route::post('/landlord/{apartment}/register-Tenant', [App\Http\Controllers\LandlordController::class, 'registerNewTenantProcess'])->name('landlord.new-user-registration');


    //IMVOICES
    //Landlord
    Route::get('/landlord/manage/invoicess', [InvoiceController::class, 'landlordShowApartmentInvoices'])->name('landlord.invoices');
    Route::get('/landlord/manage/{apartment}/invoices', [InvoiceController::class, 'landlordShowApartmentInvoices'])->name('landlord-apartment-invoices');
    Route::get('/landlord/thisMonthInvoices', [App\Http\Controllers\LandlordPaymentController::class, 'thismonth'])->name('landlord.this-month-invoices');
    Route::get('/landlord/{apartment}/invoices/{invoice}/edit', [App\Http\Controllers\LandlordPaymentController::class, 'editInvoice'])->name('landlord-edit-invoice');
    Route::post('/landlord/invoices/{invoice}/add-payment', [App\Http\Controllers\LandlordPaymentController::class, 'addPayment'])->name('invoice.landlord.addPayment');

    Route::post('/landlord/invoices/delete-invoices', [App\Http\Controllers\LandlordPaymentController::class, 'deleteInvoices'])->name('delete-invoices');

    // In web.php

Route::get('/edit-invoice/{id}', [App\Http\Controllers\LandlordPaymentController::class, 'editInvoice']);
Route::get('/fetch-invoice/{id}', [App\Http\Controllers\LandlordPaymentController::class, 'fetchInvoice']);


    Route::post('/landlord/invoices/{invoice}', [App\Http\Controllers\LandlordPaymentController::class, 'updateInvoiceItems'])->name('update-invoice');
    Route::put('/landlord/invoices/{invoice}', [App\Http\Controllers\LandlordPaymentController::class, 'updateInvoiceItems'])->name('update-invoice');
    Route::post('/landlord/invoices/{invoice}/add-payment', [App\Http\Controllers\LandlordPaymentController::class, 'addPayment'])->name('invoice.addPayment');
    Route::post('/landlord/invoices/{invoice}', [App\Http\Controllers\LandlordPaymentController::class, 'markStatus'])->name('invoice.markStatus');
    Route::post('/landlord/invoices/{invoice}/update', [App\Http\Controllers\LandlordPaymentController::class, 'update'])->name('invoices.update');
    Route::patch('/landlord/invoices/{invoice}/update', [App\Http\Controllers\LandlordPaymentController::class, 'update'])->name('invoices.update');
    Route::post('/landlord/invoices/delete-invoices', [App\Http\Controllers\LandlordPaymentController::class, 'deleteInvoices'])->name('delete-invoices');

    //delete range of generated invoices
    Route::post('/invoices/delete/{apartment}', [InvoiceController::class, 'deleteByDate'])->name('invoices.delete');

    // routes/web.php

    Route::post('/delete-selected-invoices', [App\Http\Controllers\LandlordPaymentController::class, 'deleteSelectedInvoices'])->name('delete-selected-invoices');


    Route::delete('/landlord/invoices/delete-invoices/invoices/{id}', [LandlordInvoiceController::class, 'delete'])->name('delete-invoice');
    Route::patch('/landlord/invoices/update-invoices/invoices/{id}', 'LandlordInvoiceController@update')->name('landlord.update-invoice');

    // individual user invoice
    Route::post('/create-invoice/{apartment}/{user}', [InvoiceController::class, 'createInvoice'])->name('create-invoice');
    Route::get('/create-invoice/{apartment}/{user}/{invoiceId}', [InvoiceController::class, 'showCreateInvoiceForm'])->name('show-create-invoice-form');
    Route::get('/create-invoice/{apartment}/{user}/{invoiceId}', [InvoiceController::class, 'showCreateInvoiceForm'])->name('show-create-invoice-form');
    Route::post('/publish-invoice/{invoice}', [InvoiceController::class, 'publishInvoice'])->name('publish-invoice');


    //whole apartment invoice
    Route::post('/generate-invoices/{apartment}', [InvoiceController::class, 'generateInvoices'])->name('generate-invoices');
    Route::post('/revert-invoices/{apartment}', 'InvoiceController@revertInvoices')->name('revert-invoices');
    Route::post('/update-invoice/{apartment}/{user}/{invoice}', 'InvoiceController@updateInvoice')->name('update-draft-invoice');


    //apartment

    Route::get('/landlord/apartments', [ApartmentController::class, 'showMyApartments'])->name('landlord.all-apartments');
    Route::get('/landlord/{apartment}/invoices', [InvoiceController::class, 'landlordShowApartmentInvoices'])->name('apartment-all-invoices');
    Route::get('/landlord/{apartment}/invoices/This-Month', [InvoiceController::class, 'landlordShowApartmentThisMonthInvoice'])->name('landlord.apartment-this-month-invoices');
    Route::get('/landlord/{apartment}/invoices/{user}', [InvoiceController::class, 'landlordShowUserApartmentInvoices'])->name('landlord.apartment-user-invoices');

    //user
    Route::get('/landlord/{apartment}/invoices/This-Month', [InvoiceController::class, 'landlordShowApartmentThisMonthInvoice'])->name('landlord.apartment-this-month-invoices');


    //Rooms
    Route::get('/get-room-status-options', [RoomController::class, 'getRoomStatusOptions']);
    Route::get('/get-payment-status-options', [RoomController::class, 'getPaymentStatusOptions']);
    Route::post('/update-room-and-payment-status', [RoomController::class, 'updateRoomAndPaymentStatus']);
    Route::get('/room-details/{apartmentId}/{roomId}', [RoomController::class, 'showRoomDetails'])->name('landlord.room-details');
    Route::post('/update-room-order', [RoomController::class, 'updateRoomOrder'])->name('update.room.order');
    Route::post('/room/{room}/upload-image', [RoomController::class, 'uploadImage'])->name('room.upload-image');


    //Charts
    Route::get('/apartments/{apartment}/Charts/Rooms', [ApartmentChartsController::class, 'showApartmentRooms'])->name('apartment.room-chart');

    //payments
    Route::get('/landlord/manage/{apartment}/payments', [InvoiceController::class, 'apartmentRecentPayments'])->name('landlord.apartment-payments');
    Route::post('/landlord/manage/{apartmentId}/payments/handle', [InvoiceController::class, 'handlePaymentsAction'])->name('handle_payments_action');
    Route::get('/fetch-payment-details', [PaymentsController::class, 'fetchApartmentPaymentDetails'])->name('fetch-payment-details');



    //Expenses

    Route::get('/apartments/{apartment}/expenses', [ApartmentExpensesController::class, 'show'])->name('apartment-expenses');
    Route::get('/apartments/{apartment}/expenses/create-fixed-expense', [ApartmentExpensesController::class, 'createFixedExpense'])->name('apartment-expenses.create-fixed-expense');
    Route::post('/apartments/{apartment}/expenses/store-fixed-expense', [ApartmentExpensesController::class, 'storeFixedExpense'])->name('apartment-expenses.store-fixed-expense');
    Route::delete('/apartments/{apartment}/expenses/destroy-fixed-expense/{expense}', [ApartmentExpensesController::class, 'destroyFixedExpense'])->name('apartment-expenses.destroy-fixed-expense');
    Route::get('/apartments/{apartment}/get-fixed-expenses', [ApartmentExpensesController::class, 'getFixedExpenses'])->name('apartment-expenses.get-fixed-expenses');


    Route::get('/apartments/{apartment}/expenses/create-varying-expense', [ApartmentExpensesController::class, 'createVaryingExpense'])->name('apartment-expenses.create-varying-expense');
    Route::post('/apartments/{apartment}/expenses/store-varying-expense', [ApartmentExpensesController::class, 'storeVaryingExpense'])->name('apartment-expenses.store-varying-expense');
    Route::delete('/apartments/{apartment}/expenses/destroy-varying-expense/{expense}', [ApartmentExpensesController::class, 'destroyVaryingExpense'])->name('apartment-expenses.destroy-varying-expense');

    //settings
    Route::get('/landlord/manage/{apartment}/settings', [ApartmentSettingsController::class, 'show'])->name('apartment-settings');

    Route::get('/settings', [ApartmentSettingsController::class, 'showAllSettings'])->name('all-settings');
    Route::get('/settings/{apartment}/general', [ApartmentSettingsController::class, 'showGeneralSettings'])->name('general-settings');
    Route::post('/settings/{apartment}/general', [ApartmentSettingsController::class, 'showGeneralSettings'])->name('general-settings.update');
    Route::get('/settings/{apartment}/Expenses', [ApartmentSettingsController::class, 'showExpensesSettings'])->name('expenses-settings');
    Route::get('/settings/email', [ApartmentSettingsController::class, 'showEmailSettings'])->name('email-settings');
    Route::get('/settings/{apartment}/email-Templates', [ApartmentSettingsController::class, 'showEmailTemplates'])->name('email-templates');
    Route::get('/settings/user', [ApartmentSettingsController::class, 'showUserSettings'])->name('user-settings');
    Route::get('/settings/products', [ApartmentSettingsController::class, 'showProductSettings'])->name('products-settings');
    Route::get('/settings/emails', [ApartmentSettingsController::class, 'showEmailSettings'])->name('user-management-settings');
    Route::get('/settings/user', [ApartmentSettingsController::class, 'showUserSettings'])->name('admin-users-settings');
    Route::get('/settings/invoice', [SettingsController::class, 'showProductSettings'])->name('invoice-settings');
    Route::get('/settings/roles', [ApartmentSettingsController::class, 'showEmailSettings'])->name('roles-settings');
    Route::get('/settings/{apartment}/payments-gateways', [ApartmentSettingsController::class, 'showPaymentGatewaySettings'])->name('apartment.payment-gateways-settings');
    Route::get('/settings/{apartment}/Services-Settings', [ApartmentSettingsController::class, 'showServicesSettings'])->name('apartment.services-settings');
    Route::post('/settings/{apartment}/Services-Settings', [ApartmentSettingsController::class, 'showServicesSettings'])->name('apartment.services-settings-update');

    //settings posts
    Route::post('/save-localisation-settings/{apartmentId}', [SettingsChangesController::class, 'saveLocalizationSettings'])->name('save-localisation-settings');

    // Add more routes as needed


    // Route::get('/invoices/this-month', [App\Http\Controllers\LandlordPaymentController::class, 'thisMonth'])->name('landlord.invoices');
    // Route::get('/invoices/this-month/status/{status}', [App\Http\Controllers\LandlordPaymentController::class, 'thisMonthFilteredByStatus'])->name('landlord.invoices.thisMonthFilteredByStatus');

    //Reports
    Route::get('/landlord/mymonthlyreport', [LandlordReportsController::class, 'monthlyReport'])->name('landlord.monthly-report');
    Route::get('/landlord/thismonthreport', [LandlordReportsController::class, 'ThisMonthReport'])->name('landlord.this-month-report');

    Route::get('/landlord/manage/{apartment}/reports', 'ReportController@index')->name('landlord.manage.reports')->middleware(['apartment.access']);
    Route::get('/landlord/monthlyreport/{apartment}', [LandlordReportsController::class, 'monthlyReport'])->name('apartment.monthly-report');
    Route::get('/landlord/thismonthreport/{apartment}', [LandlordReportsController::class, 'ThisMonthReport'])->name('apartment.this-month-report');
    //Users
    Route::post('/search-user', [UserController::class, 'searchUser']);
    Route::post('/add-user-to-apartment', [UserController::class, 'addUserToApartment']);

    //Route::get('/admin/Users', [App\Http\Controllers\AdminController::class, 'users'])->name('adminusers')->middleware(['is_admin'])->middleware(['apartment.access']);

    //Apartments
    //Route::get('/apartments', [App\Http\Controllers\ApartmentAssignmentController::class, 'showApartments'])->name('landlordApartments');
    //TO-DO LIST
    Route::get('/landlord/{apartment}/To-Do-List', [ApartmentController::class, 'showToDoList'])->name('apartment.to-do-list');

    //LANDLORD USER MANAGEMENT
    //licensing

    Route::get('landlord/licenseinfo', [LandlordLicenseController::class, 'show'])->name('landlord-license');
    Route::get('landlord/licenseUpgrade', [LandlordLicenseController::class, 'upgrade'])->name('licenses.upgrade-page');
    Route::get('/licenses/purchase', [LandlordLicenseController::class, 'makePurchase'])->name('licenses.purchase-page');
    Route::get('/licenses/purchase-checkout', [LandlordLicenseController::class, 'purchaseCheckout'])->name('licenses.purchase-checkout');
    Route::post('/licenses/purchase-checkout', [LandlordLicenseController::class, 'purchaseCheckout'])->name('licenses.purchase-checkout');
    Route::post('/licenses/process-payment', [LandlordLicenseController::class, 'processPayment'])->name('licenses.process-payment');
    Route::post('/licenses/store', [LandlordLicenseController::class, 'purchase'])->name('licenses.purchase-order');
    Route::post('/licenses/renew/{licensePurchase}', [LandlordLicenseController::class, 'renewLicense'])->name('licenses.renew');
    Route::get('/licenses/success', [LandlordLicenseController::class, 'success'])->name('licenses.success');

    //licenses paymnent
    // Route for initiating M-Pesa payment
    Route::get('/mpesa/process-initiate', [MpesaPaymentController::class, 'index'])->name('mpesa.process-initiate');
    Route::post('/mpesa/process', [MpesaPaymentController::class, 'process'])->name('mpesa.process');

    Route::post('/v1/mpesatest/stk/push', [MpesaSTKPUSHController::class, 'STKPush'])->name('mpesaSTKPush');

    // Route for handling M-Pesa callback or response
    Route::get('/mpesa/callback', [MpesaPaymentController::class, 'callback'])->name('mpesa.callback');
    Route::post('/mpesa/callback', [MpesaPaymentController::class, 'callback'])->name('mpesa.callback');

    // Route for initiating PayPal payment
    Route::post('/paypal/process', [PayPalPaymentController::class, 'process'])->name('paypal.process');

    // Route for handling PayPal callback or response
    Route::post('/paypal/callback', [PayPalPaymentController::class, 'callback'])->name('paypal.callback');

    // Route for initiating Visa payment
    Route::post('/visa/process', [VisaPaymentController::class, 'process'])->name('visa.process');

    // Route for handling Visa callback or response
    Route::post('/visa/callback', [VisaPaymentController::class, 'callback'])->name('visa.callback');


    Route::post('/licenses/reissue', [LandlordLicenseController::class, 'reissue'])->name('licenses.reissue');
    Route::post('/licenses/reissue,kn', [LandlordLicenseController::class, 'reissue'])->name('licenses.install-key');

    // Register Apartment
    Route::get('/apartments/create', [ApartmentController::class, 'createApartment'])->name('apartments.create');
    Route::get('/apartments/register', [ApartmentController::class, 'showCreateApartmentForm'])->name('apartments.createForm');
    Route::post('/apartments/store', [ApartmentController::class, 'create'])->name('apartments.store');


    //downloads
    Route::get('/download-pdf/{apartment}', [PdfController::class, 'generateApartmentThisMonthInvoicesPdf'])->name('download-this-month-invoices.pdf');

    //marketing
    Route::get('/Landlord-shop', [MarketingPlaceController::class, 'index'])->name('landlord-marketingplace');


});

// Routes accessible only to caretakers
Route::middleware(['auth', 'role', 'role.redirect:caretaker'])->group(function () {
    // Define caretaker-specific routes here
    // Route::get('/caretaker', function (){return Redirect::to('/home');})->name('caretaker-home');
    // Route::get('', function (){return Redirect::to('/home');})->name('caretakerhome');
    Route::get('/caretaker', [App\Http\Controllers\CaretakerController::class, 'index'])->name('caretaker-home');

});

Route::middleware(['auth', 'is_tenant', 'check.session.expired'])->group(function () {
    // Define caretaker-specific routes here
    // Route::get('/caretaker', function (){return Redirect::to('/home');})->name('caretaker-home');
    // Route::get('', function (){return Redirect::to('/home');})->name('caretakerhome');
    Route::get('/tenant', [TenantController::class, 'index'])->name('tenant-home');
    Route::get('/invoices/{id}', [App\Http\Controllers\InvoiceController::class, 'showInvoice'])->name('tenant.view-invoice');
    Route::get('/invoices', [App\Http\Controllers\InvoiceController::class, 'showUserInvoices'])->name('tenant.list-invoices');

    Route::get('/Services', [TenantServiceController::class, 'index'])->name('tenantservices.index');
    Route::post('/tenantservices/subscribe/{service}', [TenantServiceController::class, 'subscribe'])->name('tenantservices.subscribe');

    //marketing
    Route::get('/Market-Place', [MarketingPlaceController::class, 'index'])->name('tenant-marketPlace');
    Route::post('/requestapproval', [TenantServiceController::class, 'requestapproval'])->name('request-approval');

    Route::get('/rooms', [TenantServiceController::class, 'roomdetails'])->name('tenant-rooms');
    Route::get('/roomdetails/{id}', [TenantServiceController::class, 'roomdetails'])->name('tenant-room.details');
    Route::post('/selectapartment', [TenantController::class, 'selectApartment'])->name('select.apartment');
    Route::get('/tenant/apartment/{apartmentId}', 'TenantController@showApartment')->name('show.apartment');

    Route::get('/Transactions', [TenantServiceController::class, 'showTransactions'])->name('tenant-transactions');

    //settings
    Route::get('/settings', [TenantSettingsController::class, 'index'])->name('tenant-settings');
    Route::get('/myprofile', [App\Http\Controllers\ProfileController::class, 'showTenantProfile'])->name('tenant-profile.show');

});

Route::middleware(['auth', 'check.session.expired',])->group(function () {
    Route::get('/user', [App\Http\Controllers\UserController::class, 'index'])->name('user.home');

});
Route::middleware(['auth', 'check.session.expired',])->group(function () {
    Route::get('/guest', [App\Http\Controllers\UserController::class, 'dashboard'])->name('guest.home');
    Route::get('/available-rooms', [App\Http\Controllers\RoomController::class, 'showGuestAvailableRooms'])->name('guest.get.rooms');

});

Route::post('/v1/mpesatest/stk/push', [MpesaSTKPUSHController::class, 'STKPush']);

// Catch-all route for Vue Router
Route::get('/{any}', function () {
    return view('app'); // Vue app entry point
})->where('any', '.*');
