<?php $__env->startSection('content'); ?>
<style>
    /* Add the following CSS to your styles file or in the head of your HTML */

.container {
    text-align: center;
}

.license-card {
    margin-bottom: 20px;
    background-color: #b6cce2; /* Set your default background color */
    transition: background-color 0.3s ease; /* Add a smooth transition effect */
}

.license-card:hover {
    background-color: #d6d8db; /* Set the background color on hover */
}

.card-header {
    background-color: #22303f; /* Set your header background color */
    color: #fff;
    text-align: center;
}

.card-body {
    text-align: left;
}

.btn-primary {
    margin-top: 10px;
}

/* Add more styling as needed */

</style>
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-2">
          </div>
          <div class="col-sm-4">
            <h6><?php echo $__env->make('partials._message_box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></h6>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Licenses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>


<div class="container">
    <div class="row">
        <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 mb-4">
                <div class="card license-card">
                    <div class="card-header justify-content-center">
                        <div class="row">
                        <?php echo e($license->type); ?> License
                        </div>
                        <div class="row">
                            <h4> $<?php echo e($license->price); ?></h4>
                            <p>/month</p>
                        </div>


                    </div>
                    <div class="card-body">
                        <p><?php echo e($license->description); ?></p>

                        <p><span class="fa fa-check"></span>  Valid for: <?php echo e($license->expiration_cycle); ?> months</p>
                        <p><span class="fa fa-check"></span>  Support Apartments: <?php echo e($license->max_apartments); ?></p>
                        <p><span class="fa fa-check"></span>  Rooms Supported: <?php echo e($license->max_rooms); ?></p>
                        <p><span class="fa fa-check"></span>  Users Supported: <?php echo e($license->max_users); ?></p>
                        <p><span class="fa fa-check"></span>  Agents or Landlords Supported: <?php echo e($license->max_landlords); ?></p>
                        <!-- Add more license details as needed -->

<span class="fa fa-star checked"></span>
<span class="fa fa-star checked"></span>
<span class="fa fa-star checked"></span>
<span class="fa fa-star"></span>
<span class="fa fa-star"></span>
                        <form method="post" action="<?php echo e(route('licenses.purchase-checkout')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="license_type" value="<?php echo e($license->type); ?>">
                            <!-- Add more hidden fields as needed -->
                            <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Get License</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
 </div>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.landlord-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/license/purchase.blade.php ENDPATH**/ ?>