<style>
  .capitalize {
  text-transform: capitalize;
}

.email-container {
  display: flex;
  align-items: left;
  gap: 1px;
  /* align-self: auto; */
}

#sendEmailButton {
  padding: 2px;
  background-olor: #2e2f6b; /* Green background */
  color: white; /* White text */
  border: none; /* Remove borders */
  border-radius: 3px; /* Optional: Round the corners */
  cursor: pointer; /* Pointer cursor on hover */

}
#sendSMSButton {
  padding: 2px;
  background-color: #2a2b66; /* Green background */
  color: white; /* White text */
  border: none; /* Remove borders */
  border-radius: 3px; /* Optional: Round the corners */
  cursor: pointer; /* Pointer cursor on hover */

}

</style>
<div class="email-container">
    <form id="emailForm" action="<?php echo e(route('landlord-send.email')); ?>" method="POST">
      <?php echo csrf_field(); ?> <!-- CSRF protection -->
      <select name="template_id" id="emailType" class="capitalize">
        <option value="1">Invoice Created</option>
        <option value="2">First Invoice Overdue Notice</option>
        <option value="3">Second Invoice Overdue Notice</option>
        <option value="4">Third Invoice Overdue Notice</option>
        <option value="5">Invoice Payment Confirmation</option>
        <option value="6">Invoice Refund Confirmation</option>
        <option value="7">Invoice Modified</option>
      </select>
      <button type="submit" id="sendEmailButton" class="btn-primary">Send Email</button>
      <button type="submit" id="sendSMSButton" class="btn-primary">Send SMS</button>
      <input type="hidden" name="action" value=""> <!-- Hidden field to indicate action type -->
    </form>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    const emailForm = document.getElementById("emailForm");
    const sendEmailButton = document.getElementById("sendEmailButton");
    const sendSMSButton = document.getElementById("sendSMSButton");

    sendEmailButton.addEventListener("click", function() {
      // Set the action to send email
      emailForm.action = "<?php echo e(route('landlord-send.email')); ?>";
      // Set the hidden input value to "email"
      emailForm.querySelector("input[name='action']").value = "email";
      // Submit the form asynchronously
      sendForm(emailForm);
    });

    sendSMSButton.addEventListener("click", function() {
      // Set the action to send SMS
      emailForm.action = "<?php echo e(route('send.sms')); ?>";
      // Set the hidden input value to "sms"
      emailForm.querySelector("input[name='action']").value = "sms";
      // Submit the form asynchronously
      sendForm(emailForm);
    });

    function sendForm(form) {
      const formData = new FormData(form);
      fetch(form.action, {
        method: 'POST',
        body: formData
      })
      .then(response => {
        if (response.ok) {
          alert("Email/SMS sent successfully!");
        } else {
          alert("Failed to send Email/SMS. Please try again later.");
        }
      })
      .catch(error => {
        console.error('Error:', error);
        alert("An error occurred while sending Email/SMS. Please try again later.");
      });
    }
  });
// document.addEventListener("DOMContentLoaded", function() {
//   const emailForm = document.getElementById("emailForm");
//   const sendEmailButton = document.getElementById("sendEmailButton");
//   const sendSMSButton = document.getElementById("sendSMSButton");

//   sendEmailButton.addEventListener("click", function() {
//     emailForm.querySelector("input[name='action']").value = "email";
//   });

//   sendSMSButton.addEventListener("click", function() {
//     emailForm.querySelector("input[name='action']").value = "sms";
//   });
// });

  </script>
<?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/partials/_invoice_email_dropdown.blade.php ENDPATH**/ ?>