<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }

        #container {
            display: flex;
            flex-wrap: wrap;
        }

        #sidebar {
            width: 200px;
            background-color: #333;
            color: #fff;
            padding: 20px;
            box-sizing: border-box;
        }

        #content {
            flex-grow: 1;
            padding: 20px;
            box-sizing: border-box;
            display: flex;
            flex-wrap: wrap;
        }

        .sidebar-item {
            cursor: pointer;
            padding: 10px;
            margin-bottom: 10px;
            border: none;
            background: none;
            color: #fff;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .sidebar-item:hover {
            background-color: #555;
        }

        .box {
            border: 1px solid #ddd;
            margin: 10px;
            padding: 20px;
            cursor: pointer;
            transition: background-color 0.3s;
            width: calc(33.33% - 20px);
            box-sizing: border-box;
            flex-grow: 1;
            max-width: calc(33.33% - 20px);
            box-sizing: border-box;
        }

        .box:hover {
            background-color: #f0f0f0;
        }

        .box .icon {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .box .text {
            font-size: 16px;
        }

        .fade-line {
            height: 1px;
            width: 100%;
            background: linear-gradient(to right, transparent, #ddd, transparent);
            margin: 10px 0;
        }

        .content-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
            width: 100%;
            box-sizing: border-box;
        }
    </style>
</head>
<body>


<div id="container">
    <div id="sidebar">
        <div class="sidebar-item" onclick="showAllSettings()">All Settings</div>
        <div class="sidebar-item" onclick="showFilteredSettings('User Management')">User Management</div>
        <div class="sidebar-item" onclick="showFilteredSettings('Admin Users')">Admin Users</div>
        <div class="sidebar-item" onclick="showFilteredSettings('Products')">Products</div>
        <div class="sidebar-item" onclick="showFilteredSettings('Expenses')">Expenses</div>
        <div class="sidebar-item" onclick="showFilteredSettings('Services')">Services</div>
        <!-- Add more sidebar items as needed -->
    </div>

    <div id="content">
        <!-- Content will be dynamically populated here based on sidebar clicks -->
    </div>
</div>

<script>
    function navigateTo(route) {
        // Redirect to the specified Laravel route
        window.location.href = route;
    }
    showAllSettings();
    function showAllSettings() {
        // Logic to show content for all settings
        document.getElementById("content").innerHTML = `
            <div class="content-title">All Settings</div>
            <div class="box" onclick="navigateTo('<?php echo e(route('general-settings', ['apartment' => $apartment])); ?>')">
    <div class="icon">&#9873;</div>
    <div class="fade-line"></div>
    <div class="text">General Settings for Apartment <?php echo e($apartment->name); ?></div>
</div>

            <div class="box" onclick="navigateTo('<?php echo e(route('email-settings', ['apartment' => $apartment])); ?>')">
                <div class="icon">&#128232;</div>
                <div class="fade-line"></div>
                <div class="text">Email Templates</div>
            </div>
            <div class="box" onclick="navigateTo('<?php echo e(route('invoice-settings', ['apartment' => $apartment])); ?>')">
                <div class="icon">&#128337;</div>
                <div class="fade-line"></div>
                <div class="text">Invoice Settings</div>
            </div>
            <div class="box" onclick="navigateTo('<?php echo e(route('expenses-settings', ['apartment' => $apartment])); ?>')">
                <div class="icon">&#9873;</div>
                <div class="fade-line"></div>
                <div class="text">Expenses Settings</div>
            </div>
            <div class="box" onclick="navigateTo('<?php echo e(route('expenses-settings', ['apartment' => $apartment])); ?>')">
                <div class="icon">&#9873;</div>
                <div class="fade-line"></div>
                <div class="text">Roles Settings</div>
            </div>
            <div class="box" onclick="navigateTo('<?php echo e(route('expenses-settings', ['apartment' => $apartment])); ?>')">
                <div class="icon">&#9873;</div>
                <div class="fade-line"></div>
                <div class="text">Payment Settings</div>
            </div>
            <div class="box" onclick="navigateTo('<?php echo e(route('apartment.services-settings', ['apartment' => $apartment])); ?>')">
                <div class="icon">&#9873;</div>
                <div class="fade-line"></div>
                <div class="text">Services Settings</div>
            </div>


            <!-- Add more boxes for other settings -->
        `;
    }

    function showFilteredSettings(filter) {
        // Logic to filter and show content based on the selected sidebar item
        document.getElementById("content").innerHTML = `
            <div class="content-title">${filter}</div>
            <div class="box">
                <div class="icon">&#9873;</div>
                <div class="fade-line"></div>
                <div class="text">${filter} Settings</div>
            </div>
        `;
    }
   // Add more functions for other sidebar items
</script>

</body>
</html>
<?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/apartments/settings/setup.blade.php ENDPATH**/ ?>