<?php $__env->startSection('content'); ?>
<style>
    .modal {
        display: none;
        /* position: fixed;
        z-index: 1000; */
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        background-color: #fefefe;
        margin: 15% auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
    }

    .close {
        color: #aaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    .close:hover {
        color: black;
        text-decoration: none;
        cursor: pointer;
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row ">
          <div class="col-sm-6">
            <?php echo $__env->make('partials._apartment_dropdown', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          </div>
        </div>
      </div>
      <div id="apartment-data" data-apartment="<?php echo e($apartment->id); ?>"></div>
    </div>



    <section>
        <div class="container-fluid">
        <div class="row ">


                <div class="col-lg-2 col-6">



                    <div class="data-car">
                        <div href="#" class="data-card-link"target="_blank">
                            
                            <div class="small-box bg-blue" >
                                <div class="inner">
                                    <p >TOTAL USERS</p>
                                    <h4 class="center"><?php echo e($totalUsers); ?></h4>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-person-add"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-green" >
                        <div class="inner">
                            <p >Active Tenants</p>
                            <h4 class="center"><?php echo e($totalUsers); ?></h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-blue" >
                        <div class="inner">
                            <p >Guests</p>
                            <h4 class="center"><?php echo e($totalUsers); ?></h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                    </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-blue" >
                        <div class="inner">
                            <p >With Roles</p>
                            <h4 class="center"><?php echo e($totalUsers); ?></h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-yellow" >
                        <div class="inner">
                            <p>Pending Request</p>
                            <h4 class="center"><?php echo e($totalUsers); ?></h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="small-box bg-red" >
                        <div class="inner">
                            <p >Pending Delete</p>
                            <h4 class="center"><?php echo e($totalUsers); ?></h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>

        </div>
        </div>

    </section>

    <section>
        <div class="container-fluid content-header text-uppercase">
                <div>
                    <h4>Users in the Apartment</h4>
                </div>
            </div>

            <div class="container-fluid">
                <div class="col-md-12 mb-2 px-2 py-2">
                    <div class="card-header">
                        <div class="row">
                        <div class="col-md-6 d-flex justify-content-right">
                            <h3> Room:  </h3>
                        </div>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="col-lg-12">
                            <div class="main-box clearfix">
                                <div class="table-responsive">
                                    <table class="table user-list">
                                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>User Status</th>

                            <th>Room No</th>
                            <th>Room Price</th>
                            <th>Date Joined</th>
                            <th>Email</th>


                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $usersInApartment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                            <tr>
                                <td><?php echo e($user->id); ?></td>
                                <td>
                                    <img src="<?php echo e(asset('storage/' . $user->profile_picture)); ?>" alt="">
                                    

                                    <a href="<?php echo e(route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $user->id])); ?>" class="user-link"><?php echo e($user->name); ?></a>
                                    <span class="user-subhead"><?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php switch($role->name):
                                            case ('landlord'): ?>
                                                <span style="color: purple;"><?php echo e($role->name); ?></span>
                                                <?php break; ?>
                                            <?php case ('caretaker'): ?>
                                                <span style="color: blue;"><?php echo e($role->name); ?></span>
                                                <?php break; ?>
                                            <?php case ('tenant'): ?>
                                                <span style="color: black;"><?php echo e($role->name); ?></span>
                                                <?php break; ?>
                                            <?php case ('guest'): ?>
                                                <span style="color: red;"><?php echo e($role->name); ?></span>
                                                <?php break; ?>
                                            <?php default: ?>
                                                <?php echo e($role->name); ?>

                                        <?php endswitch; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </span>
                                </td>
                                <td><?php echo e($user->phone_number); ?></td>
                                <td class="text-center">
                                    <span class="label label-default"><strong>
                                        <?php if($user->status === 'active'): ?>
                                            <span style="color: green;">Active</span>
                                        <?php elseif($user->status === 'inactive'): ?>
                                            <span style="color: red;">Inactive</span>
                                        <?php else: ?>
                                            <span>Unknown</span>
                                        <?php endif; ?></span>
                                </td>
                                <td>

                                        <?php if($user->rooms->isNotEmpty()): ?>
                                            <?php echo e($user->rooms[0]->pivot->rooms_id); ?>

                                        <?php else: ?>
                                            No room assigned
                                        <?php endif; ?>
                                </td>

                                <td>
                                    price
                                </td>
                                <td>
                                    2013/08/08
                                </td>

                                <td>
                                    <a href="#">mila@kunis.com</a>
                                </td>
                                <td style="width: 20%;">
                                    <a href="#" class="table-link">
                                        <span class="fa-stack">
                                            <i class="fa fa-square fa-stack-2x"></i>
                                            <i class="fa fa-search-plus fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                    <a href="#" class="table-link">
                                        <span class="fa-stack">
                                            <i class="fa fa-square fa-stack-2x"></i>
                                            <i class="fa fa-pencil fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                    <a href="#" class="table-link danger">
                                        <span class="fa-stack">
                                            <i class="fa fa-square fa-stack-2x"></i>
                                            <i class="fa fa-trash-o fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>


    </div>
</div>       </div>
<div class="card-footer">
    Footer
</div>
                        </div>
                    </div>
                </div>
    </section>
    <button id="addUserToApartmentButton" onclick="openAddUserToApartmentPopup()">+</button>



<!-- Add this to your HTML file -->


<div class="content-wrapper">
<div id="userFormModal" class="modal-overlay mb-6">
    <div class="modal-content">
        <span class=" float-right close" onclick="closeAddUserToApartmentPopup()">&times;</span>
        <!-- Your form content goes here -->
        <form id="userForm">
            <?php echo csrf_field(); ?>
            <!-- Input fields for id, phone number, and national_id -->
            <label for="userId">User ID:</label>
            <input type="text" id="userId" name="userId" required>

            <label for="phoneNumber">Phone Number:</label>
            <input type="text" id="phoneNumber" name="phoneNumber" required>

            <label for="nationalId">National ID:</label>
            <input type="text" id="nationalId" name="nationalId" required>

            <!-- Add more fields if needed -->

            <button type="button" onclick="searchAndAddUserToApartment()">Find User</button>

            <!-- Loading spinner -->
    <div id="loadingSpinner" style="display: none;">Loading...</div>

    <!-- Search results table -->
    <table id="searchResultsTable" style="display: none;">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone Number</th>
                <th>ID Number</th>
                <th>Country</th>
                <!-- Add more columns if needed -->
            </tr>
        </thead>
        <tbody id="searchResultsBody"></tbody>
    </table>

    <!-- Button to add user to apartment (initially hidden) -->
    <button class="btn button-primary my-button"  type="button" id="addUserButton" style="display: none;">Add User to Apartment</button>


       <!-- Confirmation popup -->
       <div id="confirmationPopup" style="display: none;">
           <p>Are you sure you want to add this user to the apartment?</p>
           <button type="button" onclick="confirmAddUser()">OK</button>
           <button type="button" onclick="cancelAddUser()">Cancel</button>
       </div>
        </form>
    </div>
</div>
</div>
</div>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.apartment-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/users-in-apartment.blade.php ENDPATH**/ ?>